<?php

/**
 *  Get IP
 */
function seedprod_lite_get_ip() {
	$ip = '';
	if ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) and strlen( $_SERVER['HTTP_X_FORWARDED_FOR'] ) > 6 ) {
		$ip = strip_tags( $_SERVER['HTTP_X_FORWARDED_FOR'] );
	} elseif ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) and strlen( $_SERVER['HTTP_CLIENT_IP'] ) > 6 ) {
		$ip = strip_tags( $_SERVER['HTTP_CLIENT_IP'] );
	} elseif ( ! empty( $_SERVER['REMOTE_ADDR'] ) and strlen( $_SERVER['REMOTE_ADDR'] ) > 6 ) {
		$ip = strip_tags( $_SERVER['REMOTE_ADDR'] );
	}//endif
	if ( ! $ip ) {
		$ip = '127.0.0.1';
	}
	return strip_tags( $ip );
}

/**
 * Update cookie length for bypass url
 */
function seedprod_lite_change_wp_cookie_logout( $expirein ) {
	global $seed_cspv5_bypass_expires;
	if ( ! empty( $seed_cspv5_bypass_expires ) ) {
		return $seed_cspv5_bypass_expires; // Modify the exire cookie
	} else {
		return $expirein;
	}
}


/**
 * Get roles
 */
function seedprod_lite_get_roles() {
	global $wp_roles;

	if ( ! isset( $wp_roles ) ) {
		$wp_roles = new WP_Roles();
	}
	$roles = $wp_roles->get_names();

	if ( is_multisite() ) {
		$roles['superadmin'] = __( 'SuperAdmin', 'coming-soon' );
	}
	$roles['anyoneloggedin'] = __( 'Anyone Logged In', 'coming-soon' );

	return $roles;
}


/**
* Get Enviroment
*/
function seedprod_lite_is_localhost() {
	// $localhost = array('127.0.0.1','::1');

	// $is_localhost = false;
	// if (in_array($_SERVER['REMOTE_ADDR'], $localhost) || !empty($_GET['debug'])) {
	//     $is_localhost = true;
	// }
	$is_localhost = false;
	if ( defined( 'SEEDPROD_LOCAL_JS' ) ) {
		$is_localhost = true;
	}

	return $is_localhost;
}

// YouTube video ID
function seedprod_lite_youtube_id_from_url( $url ) {
	$pattern =
		'%^# Match any youtube URL
        (?:https?://)?  # Optional scheme. Either http or https
        (?:www\.)?      # Optional www subdomain
        (?:             # Group host alternatives
          youtu\.be/    # Either youtu.be,
        | youtube\.com  # or youtube.com
          (?:           # Group path alternatives
            /embed/     # Either /embed/
          | /v/         # or /v/
          | /watch\?v=  # or /watch\?v=
          )             # End path alternatives.
        )               # End host alternatives.
        ([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
        $%x';
	$result  = preg_match( $pattern, $url, $matches );
	if ( false !== $result ) {
		if ( isset( $matches[1] ) ) {
			return $matches[1];
		}
	}
	return false;
}

/**
* Entry Options
*/
function seedprod_lite_block_options() {
	 $block_options = array(
		 array(
			 'name'   => __( 'Column', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'layout',
			 'type'   => 'column',
			 'id'     => 1,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6  sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M4 5v13h17V5H4zm10 2v9h-3V7h3zM6 7h3v9H6V7zm13 9h-3V7h3v9z"/></svg>',
		 ),
		 // array('name'=>__('2 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'2-col', 'id'=>2),
		 // array('name'=>__('3 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'3-col', 'id'=>3),
		 // array('name'=>__('4 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'4-col', 'id'=>4),
		 // array('name'=>__('5 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'5-col', 'id'=>5),
		 // array('name'=>__('6 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'6-col', 'id'=>6),
		 // array('name'=>__('Left Sidebar','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'left-sidebar', 'id'=>7),
		 // array('name'=>__('Right Sidebar','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'right-sidebar', 'id'=>8),

		 // array('name'=>__('6 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'6-col', 'id'=>6),

		 array(
			 'name'   => __( 'Headline', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'header',
			 'id'     => 9,
			 'icon'   => '<svg viewBox="0 0 12 17" class="sp-w-14px  sp-fill-current sp-pb-2" xmlns="http://www.w3.org/2000/svg">
        <path d="M9 0.800049V7.04005H3V0.800049H0V16.4H3V10.16H9V16.4H12V0.800049H9Z"/>
        </svg>
        ',
		 ),
		 //array('name'=>__('Sub Headline','coming-soon'),'is_pro'=> false,'cat'=>'common','type'=>'sub-header', 'id'=>10, 'icon' => 'fas fa-heading'),
		 array(
			 'name'   => __( 'Text', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'text',
			 'id'     => 11,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class="sp-w-6 sp-fill-current "><rect x="0" fill="none"/><g><path d="M15 2H7.54c-.83 0-1.59.2-2.28.6-.7.41-1.25.96-1.65 1.65C3.2 4.94 3 5.7 3 6.52s.2 1.58.61 2.27c.4.69.95 1.24 1.65 1.64.69.41 1.45.61 2.28.61h.43V17c0 .27.1.51.29.71.2.19.44.29.71.29.28 0 .51-.1.71-.29.2-.2.3-.44.3-.71V5c0-.27.09-.51.29-.71.2-.19.44-.29.71-.29s.51.1.71.29c.19.2.29.44.29.71v12c0 .27.1.51.3.71.2.19.43.29.71.29.27 0 .51-.1.71-.29.19-.2.29-.44.29-.71V4H15c.27 0 .5-.1.7-.3.2-.19.3-.43.3-.7s-.1-.51-.3-.71C15.5 2.1 15.27 2 15 2z"/></g></svg>',
		 ),
		 array(
			 'name'   => __( 'List', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'bullet-list',
			 'id'     => 12,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current"><g fill="none"><path d="M0 0h24v24H0V0z"/><path d="M0 0h24v24H0V0z" opacity=".87"/></g><path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7zm-4 6h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Button', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'button',
			 'id'     => 13,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" class="sp-w-6 sp-fill-current "  viewBox="0 0 24 24" ><g><rect fill="none" height="24" width="24"/></g><g><g><path d="M18.19,12.44l-3.24-1.62c1.29-1,2.12-2.56,2.12-4.32c0-3.03-2.47-5.5-5.5-5.5s-5.5,2.47-5.5,5.5c0,2.13,1.22,3.98,3,4.89 v3.26c-2.15-0.46-2.02-0.44-2.26-0.44c-0.53,0-1.03,0.21-1.41,0.59L4,16.22l5.09,5.09C9.52,21.75,10.12,22,10.74,22h6.3 c0.98,0,1.81-0.7,1.97-1.67l0.8-4.71C20.03,14.32,19.38,13.04,18.19,12.44z M17.84,15.29L17.04,20h-6.3 c-0.09,0-0.17-0.04-0.24-0.1l-3.68-3.68l4.25,0.89V6.5c0-0.28,0.22-0.5,0.5-0.5c0.28,0,0.5,0.22,0.5,0.5v6h1.76l3.46,1.73 C17.69,14.43,17.91,14.86,17.84,15.29z M8.07,6.5c0-1.93,1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5c0,0.95-0.38,1.81-1,2.44V6.5 c0-1.38-1.12-2.5-2.5-2.5c-1.38,0-2.5,1.12-2.5,2.5v2.44C8.45,8.31,8.07,7.45,8.07,6.5z"/></g></g></svg>',
		 ),
		 array(
			 'name'   => __( 'Image', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'image',
			 'id'     => 14,
			 'icon'   => '<svg  class="sp-w-6 sp-fill-current " xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4.86 8.86l-3 3.87L9 13.14 6 17h12l-3.86-5.14z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Video', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'video',
			 'id'     => 15,
			 'icon'   => '<svg  class="sp-w-6 sp-fill-current " xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" ><path d="M0 0h24v24H0V0z" fill="none"/><path d="M15 8v8H5V8h10m1-2H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4V7c0-.55-.45-1-1-1z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Divider', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'divider',
			 'id'     => 17,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><g><rect fill="none" height="24" width="24"/></g><g><g><g><path d="M20,9H4v2h16V9z M4,15h16v-2H4V15z"/></g></g></g></svg>',
		 ),
		 array(
			 'name'   => __( 'Spacer', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'common',
			 'type'   => 'spacer',
			 'id'     => 24,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current sp-transform sp-rotate-90" ><path d="M0 0h24v24H0z" fill="none"/><path d="M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Giveaway', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'adv',
			 'type'   => 'giveaway',
			 'id'     => 32,
			 'icon'   => '<svg class="sp-w-5 sp-fill-current " viewBox="0 0 394 416" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <path d="M161.294,281.219 C151.445,281.219 143.462,289.202 143.462,299.049 C143.462,308.896 151.445,316.878 161.294,316.878 C171.139,316.878 179.122,308.896 179.122,299.049 C179.122,289.202 171.139,281.219 161.294,281.219 Z M232.979,281.219 C223.132,281.219 215.149,289.202 215.149,299.049 C215.149,308.896 223.132,316.878 232.979,316.878 C242.826,316.878 250.806,308.896 250.806,299.049 C250.806,289.202 242.826,281.219 232.979,281.219 Z M32.608,123.757 C30.714,158.655 31.726,255.445 32.608,292.617 C32.68,295.618 34.565,297.889 37.042,299.527 C58.017,313.458 79.698,326.395 101.835,338.541 C98.77,308.445 98.261,273.714 107.731,252.542 C111.467,244.191 119.577,237.434 130.383,232.272 C111.019,204.919 98.751,172.762 95.699,143.461 C91.243,100.685 159.191,80.829 161.091,113.506 C163.202,149.839 167.026,185.74 173.214,221.056 C180.966,220.166 188.963,219.72 196.962,219.708 C205.077,219.704 213.195,220.154 221.06,221.056 C227.245,185.74 231.071,149.839 233.18,113.506 C235.079,80.829 303.03,100.685 298.574,143.461 C295.523,172.762 283.254,204.919 263.891,232.272 C274.694,237.434 282.806,244.191 286.542,252.542 C295.99,273.665 295.504,308.286 292.458,338.332 C314.469,326.252 336.023,313.381 356.885,299.527 C359.356,297.889 361.245,295.618 361.316,292.617 C362.199,255.445 363.21,158.655 361.316,123.757 C361.008,120.766 359.356,118.487 356.885,116.846 C307.739,84.205 254.723,57.023 201.025,32.736 C199.667,32.123 198.314,31.818 196.962,31.818 C195.61,31.818 194.257,32.123 192.902,32.736 C139.201,57.023 86.185,84.205 37.042,116.846 C34.565,118.487 32.913,120.766 32.608,123.757 Z M1.328,120.554 C2.595,108.178 9.333,97.499 19.644,90.651 C70.294,57.012 124.602,29.116 179.943,4.087 C190.893,-0.864 203.032,-0.864 213.981,4.087 C269.323,29.116 323.628,57.012 374.28,90.651 C384.913,97.713 392.019,109.24 392.712,122.052 C394.273,150.787 393.913,180.541 393.792,209.337 C393.674,237.33 393.416,265.374 392.75,293.359 C392.432,306.785 385.326,318.385 374.28,325.719 C323.628,359.361 269.323,387.262 213.981,412.29 C203.032,417.237 190.893,417.237 179.943,412.29 C124.602,387.262 70.294,359.361 19.644,325.719 C8.596,318.385 1.493,306.785 1.174,293.359 C0.509,265.374 0.248,237.33 0.132,209.337 C0.047,189.407 -0.464,137.991 1.328,120.554 L1.328,120.554 Z" id="Fill-5"></path>
        </svg>',
		 ),

		 array(
			 'name'   => __( 'Contact Form', 'coming-soon' ),
			 'is_pro' => false,
			 'cat'    => 'adv',
			 'type'   => 'contact-form',
			 'id'     => 23,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="sp-w-5 sp-fill-current "><path fill="currentColor" d="M448 75.2v361.7c0 24.3-19 43.2-43.2 43.2H43.2C19.3 480 0 461.4 0 436.8V75.2C0 51.1 18.8 32 43.2 32h361.7c24 0 43.1 18.8 43.1 43.2zm-37.3 361.6V75.2c0-3-2.6-5.8-5.8-5.8h-9.3L285.3 144 224 94.1 162.8 144 52.5 69.3h-9.3c-3.2 0-5.8 2.8-5.8 5.8v361.7c0 3 2.6 5.8 5.8 5.8h361.7c3.2.1 5.8-2.7 5.8-5.8zM150.2 186v37H76.7v-37h73.5zm0 74.4v37.3H76.7v-37.3h73.5zm11.1-147.3l54-43.7H96.8l64.5 43.7zm210 72.9v37h-196v-37h196zm0 74.4v37.3h-196v-37.3h196zm-84.6-147.3l64.5-43.7H232.8l53.9 43.7zM371.3 335v37.3h-99.4V335h99.4z"></path></svg>',
		 ),

		 array(
			 'name'   => __( 'Optin Form', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'optin-form',
			 'id'     => 22,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6zm-2 0l-8 4.99L4 6h16zm0 12H4V8l8 5 8-5v10z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Countdown', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'countdown',
			 'id'     => 16,
			 'icon'   => '
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M15.07 1.01h-6v2h6v-2zm-4 13h2v-6h-2v6zm8.03-6.62l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42C16.14 4.74 14.19 4 12.07 4c-4.97 0-9 4.03-9 9s4.02 9 9 9 9-4.03 9-9c0-2.11-.74-4.06-1.97-5.61zm-7.03 12.62c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Social Profiles', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'social-profiles',
			 'id'     => 18,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M9 13.75c-2.34 0-7 1.17-7 3.5V19h14v-1.75c0-2.33-4.66-3.5-7-3.5zM4.34 17c.84-.58 2.87-1.25 4.66-1.25s3.82.67 4.66 1.25H4.34zM9 12c1.93 0 3.5-1.57 3.5-3.5S10.93 5 9 5 5.5 6.57 5.5 8.5 7.07 12 9 12zm0-5c.83 0 1.5.67 1.5 1.5S9.83 10 9 10s-1.5-.67-1.5-1.5S8.17 7 9 7zm7.04 6.81c1.16.84 1.96 1.96 1.96 3.44V19h4v-1.75c0-2.02-3.5-3.17-5.96-3.44zM15 12c1.93 0 3.5-1.57 3.5-3.5S16.93 5 15 5c-.54 0-1.04.13-1.5.35.63.89 1 1.98 1 3.15s-.37 2.26-1 3.15c.46.22.96.35 1.5.35z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Social Sharing', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'social-sharing',
			 'id'     => 19,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92c0-1.61-1.31-2.92-2.92-2.92zM18 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM6 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm12 7.02c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/></svg>',
		 ),
		 //array('name'=>__('Form','coming-soon'),'is_pro'=> false  ,'cat'=>'adv','type'=>'form', 'id'=>25, 'icon' => 'far fa-envelope'),
		 array(
			'name'   => __( 'Animated Headline', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'animatedheadline',
			'id'     => 11,
			'icon'   => '<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
		   <path fill-rule="evenodd" clip-rule="evenodd" d="M6.92423 2V22.4525H10.5335V13.297H20.1582V22.4525H23.7675V2H20.1582V10.4216H10.5335V2H6.92423ZM23.178 27.8784C23.3427 28.0179 23.5516 28.0947 23.7675 28.095C23.9501 28.0753 24.1223 28.0004 24.2612 27.8803C24.4001 27.7602 24.499 27.6006 24.5448 27.4227C24.5905 27.2449 24.5809 27.0573 24.5173 26.8851C24.4536 26.7128 24.339 26.5641 24.1886 26.4588L22.1674 24.7263C21.7878 24.3938 21.3004 24.2105 20.7959 24.2105C20.2913 24.2105 19.8039 24.3938 19.4243 24.7263L18.2212 25.785C18.1653 25.831 18.0951 25.8561 18.0227 25.8561C17.9503 25.8561 17.8802 25.831 17.8242 25.785L16.6211 24.7263C16.2416 24.3938 15.7542 24.2105 15.2496 24.2105C14.745 24.2105 14.2576 24.3938 13.8781 24.7263L12.675 25.785C12.6191 25.831 12.5489 25.8561 12.4765 25.8561C12.4041 25.8561 12.3339 25.831 12.278 25.785L11.0749 24.7263C10.6954 24.3938 10.208 24.2105 9.70337 24.2105C9.19879 24.2105 8.71139 24.3938 8.33185 24.7263L6.31067 26.4588C6.12879 26.6183 6.01774 26.8436 6.00195 27.085C5.98615 27.3264 6.06691 27.5642 6.22645 27.7461C6.38599 27.928 6.61124 28.039 6.85266 28.0548C7.09408 28.0706 7.33188 27.9898 7.51375 27.8303L9.67931 26.1339C9.73527 26.088 9.80542 26.0629 9.87782 26.0629C9.95022 26.0629 10.0204 26.088 10.0763 26.1339L11.2794 27.2047C11.6623 27.5302 12.1484 27.7089 12.6509 27.7089C13.1535 27.7089 13.6396 27.5302 14.0225 27.2047L15.2256 26.1339C15.2785 26.0866 15.347 26.0604 15.418 26.0604C15.4891 26.0604 15.5576 26.0866 15.6105 26.1339L16.8136 27.2047C17.1965 27.5302 17.6826 27.7089 18.1851 27.7089C18.6877 27.7089 19.1738 27.5302 19.5567 27.2047L20.7598 26.1339C20.8157 26.088 20.8859 26.0629 20.9583 26.0629C21.0307 26.0629 21.1008 26.088 21.1568 26.1339L23.178 27.8784Z" />
		   </svg>
		   
',
		),
		 array(
			 'name'   => __( 'Progress Bar', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'progress-bar',
			 'id'     => 24,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24"  class="sp-w-6 sp-fill-current sp-transform sp-rotate-90"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M5 9.2h3V19H5V9.2zM10.6 5h2.8v14h-2.8V5zm5.6 8H19v6h-2.8v-6z"/></svg>',
		 ),
		 array(
			 'name'   => __( 'Icon', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'icon',
			 'id'     => 24,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M16.5 3c-1.74 0-3.41.81-4.5 2.09C10.91 3.81 9.24 3 7.5 3 4.42 3 2 5.42 2 8.5c0 3.78 3.4 6.86 8.55 11.54L12 21.35l1.45-1.32C18.6 15.36 22 12.28 22 8.5 22 5.42 19.58 3 16.5 3zm-4.4 15.55l-.1.1-.1-.1C7.14 14.24 4 11.39 4 8.5 4 6.5 5.5 5 7.5 5c1.54 0 3.04.99 3.57 2.36h1.87C13.46 5.99 14.96 5 16.5 5c2 0 3.5 1.5 3.5 3.5 0 2.89-3.14 5.74-7.9 10.05z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Testimonials', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'testimonial',
			 'id'     => 34,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H6l-2 2V4h16v12z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Image Carousel', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'imagecarousel',
			 'id'     => 45,
			 'icon'   => '
			 <svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
			 <path fill-rule="evenodd" clip-rule="evenodd" d="M6.10999 4H23.89C24.1959 4.01301 24.4843 4.14646 24.6923 4.37126C24.9002 4.59606 25.0108 4.89397 25 5.2V20.76C25.0108 21.066 24.9002 21.3639 24.6923 21.5887C24.4843 21.8135 24.1959 21.947 23.89 21.96H6.10999C5.80405 21.947 5.51565 21.8135 5.30771 21.5887C5.09977 21.3639 4.98916 21.066 5 20.76V5.2C4.98916 4.89397 5.09977 4.59606 5.30771 4.37126C5.51565 4.14646 5.80405 4.01301 6.10999 4ZM22.78 6.4H7.21999V17.2L12.66 9.38L17.22 14.31L22.78 8.31V6.4ZM12.9 13.03L8.32999 19.6H22.78V11.7L17.22 17.7L12.9 13.03ZM16 24.52C16 25.0723 15.5523 25.52 15 25.52C14.4477 25.52 14 25.0723 14 24.52C14 23.9677 14.4477 23.52 15 23.52C15.5523 23.52 16 23.9677 16 24.52ZM11 25.52C11.5523 25.52 12 25.0723 12 24.52C12 23.9677 11.5523 23.52 11 23.52C10.4477 23.52 10 23.9677 10 24.52C10 25.0723 10.4477 25.52 11 25.52ZM20 24.52C20 25.0723 19.5523 25.52 19 25.52C18.4477 25.52 18 25.0723 18 24.52C18 23.9677 18.4477 23.52 19 23.52C19.5523 23.52 20 23.9677 20 24.52ZM26.85 11.52L29 13.67L26.85 15.82V11.52ZM1 13.67L3.15 15.82V11.52L1 13.67Z" />
			 </svg>
			 ',
		 ),

		 array(
			 'name'   => __( 'Image Box', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'feature',
			 'id'     => 24,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM4 6h9v7H4z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Icon Box', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'iconfeature',
			 'id'     => 26,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM5 10h9v2H5zm0-3h9v2H5z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Nav Menu', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'nav',
			 'id'     => 25,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0z" fill="none"/><path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"/></svg>',
		 ),
		 array(
			'name'   => __( 'Pricing Table', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'pricingtable',
			'id'     => 44,
			'icon'   => '<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
			   <path fill-rule="evenodd" clip-rule="evenodd" d="M21 26.5V3H9.5C9.36739 3 9.24021 3.05268 9.14645 3.14645C9.05268 3.24021 9 3.36739 9 3.5V26.5C9 26.6326 9.05268 26.7598 9.14645 26.8536C9.24021 26.9473 9.36739 27 9.5 27H20.5C20.6326 27 20.7598 26.9473 20.8536 26.8536C20.9473 26.7598 21 26.6326 21 26.5ZM8 1H22C22.2652 1 22.5196 1.10536 22.7071 1.29289C22.8946 1.48043 23 1.73478 23 2V3H27.17C27.6776 3.02336 28.1552 3.24698 28.4983 3.62186C28.8413 3.99675 29.0217 4.49233 29 5V25C29.0217 25.5077 28.8413 26.0033 28.4983 26.3781C28.1552 26.753 27.6776 26.9766 27.17 27H23V28C23 28.2652 22.8946 28.5196 22.7071 28.7071C22.5196 28.8946 22.2652 29 22 29H8C7.73478 29 7.48043 28.8946 7.29289 28.7071C7.10536 28.5196 7 28.2652 7 28V27H2.83C2.3224 26.9766 1.84476 26.753 1.50174 26.3781C1.15871 26.0033 0.978291 25.5077 1 25V5C0.978291 4.49233 1.15871 3.99675 1.50174 3.62186C1.84476 3.24698 2.3224 3.02336 2.83 3H7V2C7 1.73478 7.10536 1.48043 7.29289 1.29289C7.48043 1.10536 7.73478 1 8 1ZM7 5V25H3.51C3.37739 25 3.25022 24.9473 3.15645 24.8536C3.06268 24.7598 3.01 24.6326 3.01 24.5V5.5C3.01 5.36739 3.06268 5.24021 3.15645 5.14645C3.25022 5.05268 3.37739 5 3.51 5H7ZM23 25H26.49C26.6226 25 26.7498 24.9473 26.8436 24.8536C26.9373 24.7598 26.99 24.6326 26.99 24.5V5.5C26.99 5.36739 26.9373 5.24021 26.8436 5.14645C26.7498 5.05268 26.6226 5 26.49 5H23V25ZM14.52 6.38H15.52V7.52C15.746 7.56137 15.9697 7.61478 16.19 7.68C16.426 7.74892 16.6514 7.84986 16.86 7.98L16.45 9.08C16.2355 8.96937 16.0112 8.87897 15.78 8.81001C15.5278 8.72993 15.2646 8.68945 15 8.69C14.807 8.68258 14.616 8.7312 14.45 8.83C14.3798 8.87052 14.3216 8.92884 14.2812 8.99908C14.2408 9.06932 14.2197 9.14898 14.22 9.23C14.2191 9.30637 14.2369 9.38179 14.2717 9.44975C14.3066 9.5177 14.3575 9.57614 14.42 9.62C14.6283 9.75956 14.858 9.86427 15.1 9.93001L15.59 10.1C16.0513 10.2242 16.4676 10.4774 16.79 10.83C17.0646 11.1658 17.2146 11.5862 17.2146 12.02C17.2146 12.4538 17.0646 12.8742 16.79 13.21C16.4155 13.5952 15.9151 13.833 15.38 13.88V15.09H14.38V13.9C13.7692 13.844 13.1818 13.6379 12.67 13.3L13.18 12.23C13.4086 12.3927 13.6618 12.5176 13.93 12.6C14.1774 12.6701 14.4329 12.7071 14.69 12.71C14.9501 12.7383 15.2119 12.6746 15.43 12.53C15.4872 12.4797 15.5335 12.4184 15.5662 12.3496C15.5989 12.2808 15.6172 12.2061 15.62 12.13C15.6195 12.0569 15.6042 11.9846 15.575 11.9176C15.5458 11.8505 15.5033 11.7901 15.45 11.74C15.2683 11.5906 15.057 11.4815 14.83 11.42L14.29 11.24C14.0692 11.1687 13.8551 11.0784 13.65 10.97C13.4589 10.8655 13.2838 10.7342 13.13 10.58C12.981 10.4249 12.8593 10.2457 12.77 10.05C12.6799 9.83131 12.6357 9.59647 12.64 9.36C12.634 9.1127 12.6818 8.86705 12.78 8.64001C12.8745 8.42552 13.0104 8.23182 13.18 8.07001C13.3504 7.90178 13.5551 7.77219 13.78 7.69C14.0206 7.59946 14.2734 7.54553 14.53 7.53L14.52 6.38ZM10.5 17H19.5C19.7761 17 20 17.2239 20 17.5C20 17.7761 19.7761 18 19.5 18H10.5C10.2239 18 10 17.7761 10 17.5C10 17.2239 10.2239 17 10.5 17ZM19.5 20H10.5C10.2239 20 10 20.2239 10 20.5C10 20.7761 10.2239 21 10.5 21H19.5C19.7761 21 20 20.7761 20 20.5C20 20.2239 19.7761 20 19.5 20ZM10.5 23H19.5C19.7761 23 20 23.2239 20 23.5C20 23.7761 19.7761 24 19.5 24H10.5C10.2239 24 10 23.7761 10 23.5C10 23.2239 10.2239 23 10.5 23Z" />
			   </svg>
		   ',
		),

		 array(
			 'name'   => __( 'Anchor', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'anchor',
			 'id'     => 30,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current" ><path d="M17,15l1.55,1.55c-0.96,1.69-3.33,3.04-5.55,3.37V11h3V9h-3V7.82C14.16,7.4,15,6.3,15,5c0-1.65-1.35-3-3-3S9,3.35,9,5 c0,1.3,0.84,2.4,2,2.82V9H8v2h3v8.92c-2.22-0.33-4.59-1.68-5.55-3.37L7,15l-4-3v3c0,3.88,4.92,7,9,7s9-3.12,9-7v-3L17,15z M12,4 c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,4,12,4z"/></g></svg>',
		 ),

		 array(
			 'name'   => __( 'Star Rating', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'starrating',
			 'id'     => 31,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 7.13l.97 2.29.47 1.11 1.2.1 2.47.21-1.88 1.63-.91.79.27 1.18.56 2.41-2.12-1.28-1.03-.64-1.03.62-2.12 1.28.56-2.41.27-1.18-.91-.79-1.88-1.63 2.47-.21 1.2-.1.47-1.11.97-2.27M12 2L9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Accordion', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'accordion',
			 'id'     => 34,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 18H2v2h19v-2zm-2-8v4H4v-4h15m1-2H3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h17c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm1-4H2v2h19V4z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Shortcode', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'shortcode',
			 'id'     => 21,
			 'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="sp-w-6 sp-fill-current"><path d="M256 8C119.3 8 8 119.2 8 256c0 136.7 111.3 248 248 248s248-111.3 248-248C504 119.2 392.7 8 256 8zM33 256c0-32.3 6.9-63 19.3-90.7l106.4 291.4C84.3 420.5 33 344.2 33 256zm223 223c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2L200.6 393l-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3C109.6 73 178.1 33 256 33c58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Login Form', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'login',
			 'id'     => 33,
			 'icon'   => '
         <svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " enable-background="new 0 0 24 24" height="24" viewBox="0 0 24 24" width="24"><g><rect fill="none" height="24" width="24"/></g><g><path d="M11,7L9.6,8.4l2.6,2.6H2v2h10.2l-2.6,2.6L11,17l5-5L11,7z M20,19h-8v2h8c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2h-8v2h8V19z"/></g></svg>',
		 ),


		 array(
			'name'   => __( 'Google Maps', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'googlemaps',
			'id'     => 50,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " enable-background="new 0 0 30 30" height="30" viewBox="0 0 30 30" width="30"><g><rect fill="none" height="30" width="30"/></g><g><path d="M26.3333 3L26.12 3.04L19 5.8L11 3L3.48 5.53333C3.2 5.62667 3 5.86667 3 6.17333V26.3333C3 26.7067 3.29333 27 3.66667 27L3.88 26.96L11 24.2L19 27L26.52 24.4667C26.8 24.3733 27 24.1333 27 23.8267V3.66667C27 3.29333 26.7067 3 26.3333 3ZM19 24.3333L11 21.52V5.66667L19 8.48V24.3333Z"/></g></svg>',
		),


		 array(
			 'name'   => __( 'Facebook Like', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'facebooklike',
			 'id'     => 35,
			 'icon'   => '
		         <svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
		         <path d="M11.66 14.44H7.02C7.00895 14.44 7 14.449 7 14.46V22.5C7 22.511 7.00895 22.52 7.02 22.52H11.66C11.671 22.52 11.68 22.511 11.68 22.5V14.46C11.68 14.449 11.671 14.44 11.66 14.44Z" />
		         <path d="M23 16.58C23.0003 16.3506 22.9544 16.1235 22.865 15.9121C22.7757 15.7008 22.6448 15.5097 22.48 15.35C22.7099 15.0664 22.84 14.715 22.85 14.35C22.8473 13.9028 22.6676 13.4749 22.35 13.16C22.0146 12.8194 21.558 12.6252 21.08 12.62H17.35L17.59 11C17.6217 10.8015 17.6384 10.601 17.64 10.4C17.64 8.88001 16.64 7.10001 15.27 7.10001C14.9031 7.10899 14.5503 7.24306 14.27 7.48001L14.13 7.60001L14.32 10.13C14.3352 10.2361 14.3352 10.3439 14.32 10.45C14.2922 10.5545 14.252 10.6552 14.2 10.75L12.2 14.52L12.13 14.58C12.1036 14.4113 12.0172 14.2579 11.8868 14.1477C11.7564 14.0375 11.5907 13.9779 11.42 13.98H7.37C7.27592 13.9787 7.18252 13.9961 7.09522 14.0312C7.00792 14.0662 6.92847 14.1183 6.86148 14.1844C6.79448 14.2505 6.74129 14.3292 6.70499 14.416C6.66868 14.5028 6.64999 14.5959 6.65 14.69V22.13C6.64999 22.2241 6.66868 22.3172 6.70499 22.404C6.74129 22.4908 6.79448 22.5696 6.86148 22.6356C6.92847 22.7017 7.00792 22.7538 7.09522 22.7889C7.18252 22.8239 7.27592 22.8413 7.37 22.84H11.31C11.4983 22.84 11.6789 22.7652 11.812 22.6321C11.9452 22.4989 12.02 22.3183 12.02 22.13V21.75C12.5073 22.1373 13.1077 22.3549 13.73 22.37H19.67C20.1027 22.3498 20.5116 22.1662 20.8141 21.8563C21.1167 21.5463 21.2903 21.1331 21.3 20.7C21.3153 20.5638 21.3153 20.4262 21.3 20.29C21.6037 20.1543 21.8605 19.932 22.0384 19.6509C22.2163 19.3698 22.3073 19.0425 22.3 18.71C22.3024 18.4834 22.2582 18.2587 22.17 18.05C22.4224 17.8963 22.6312 17.6804 22.7765 17.4231C22.9218 17.1658 22.9987 16.8755 23 16.58ZM11.33 22.16H7.37V14.72H11.31V22.16H11.33ZM21.57 17.56L21.1 17.7L21.39 18.1C21.5255 18.2746 21.5993 18.4891 21.6 18.71C21.6027 18.9512 21.5182 19.1852 21.362 19.369C21.2058 19.5527 20.9885 19.6738 20.75 19.71L20.28 19.79L20.5 20.22C20.5745 20.3653 20.6123 20.5267 20.61 20.69C20.61 20.9552 20.5046 21.2096 20.3171 21.3971C20.1296 21.5846 19.8752 21.69 19.61 21.69H13.74C13.2818 21.6743 12.8405 21.5132 12.48 21.23C12.3821 21.1426 12.2707 21.0716 12.15 21.02L12 21V15.52L12.62 14.99L14.7 11.13C14.7912 10.9814 14.8586 10.8194 14.9 10.65C14.9463 10.474 14.9632 10.2915 14.95 10.11L14.8 8.00001C14.9435 7.91855 15.105 7.87389 15.27 7.87001C16.17 7.87001 16.94 9.31001 16.94 10.48C16.9502 10.6432 16.9502 10.8068 16.94 10.97L16.57 13.31H21.09C21.3832 13.3137 21.6632 13.4322 21.87 13.64C21.9645 13.7326 22.0397 13.8431 22.0912 13.9649C22.1427 14.0868 22.1695 14.2177 22.17 14.35C22.1652 14.5068 22.126 14.6607 22.0552 14.8006C21.9843 14.9406 21.8835 15.0633 21.76 15.16L21.34 15.48L21.8 15.74C21.9847 15.8301 22.1372 15.9749 22.2367 16.1548C22.3362 16.3346 22.3779 16.5408 22.356 16.7452C22.3341 16.9495 22.2498 17.1422 22.1146 17.297C21.9793 17.4517 21.7996 17.561 21.6 17.61L21.57 17.56Z" />
		         <path d="M25.48 27.93H4.48C3.82043 27.9247 3.18967 27.659 2.72515 27.1907C2.26062 26.7225 1.99998 26.0896 2 25.43V4.42999C2 3.76695 2.26339 3.13107 2.73223 2.66223C3.20107 2.19338 3.83696 1.92999 4.5 1.92999H25.5C26.163 1.92999 26.7989 2.19338 27.2678 2.66223C27.7366 3.13107 28 3.76695 28 4.42999V25.43C28 25.76 27.9347 26.0867 27.8078 26.3913C27.6809 26.696 27.495 26.9725 27.2607 27.2049C27.0264 27.4373 26.7485 27.621 26.4429 27.7455C26.1372 27.8699 25.81 27.9326 25.48 27.93ZM4.48 3.92999C4.34819 3.93255 4.2225 3.98605 4.12928 4.07927C4.03606 4.17249 3.98256 4.29819 3.98 4.42999V25.43C3.98 25.5626 4.03268 25.6898 4.12645 25.7835C4.22021 25.8773 4.34739 25.93 4.48 25.93H25.48C25.6126 25.93 25.7398 25.8773 25.8336 25.7835C25.9273 25.6898 25.98 25.5626 25.98 25.43V4.42999C25.98 4.29738 25.9273 4.17021 25.8336 4.07644C25.7398 3.98267 25.6126 3.92999 25.48 3.92999H4.48Z" />
		         </svg>',
		 ),


		 array(
			 'name'   => __( 'Facebook Comments', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'facebookcomments',
			 'id'     => 36,
			 'icon'   => '<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
		         <path fill-rule="evenodd" clip-rule="evenodd" d="M3.13 28C2.94034 27.9985 2.75305 27.9576 2.58 27.88C2.31249 27.7733 2.08344 27.5882 1.92286 27.3491C1.76227 27.11 1.67762 26.828 1.68 26.54V5.34999C1.68 4.37665 2.06666 3.44317 2.75492 2.75491C3.44318 2.06665 4.37666 1.67999 5.35 1.67999H24.65C25.6225 1.68263 26.5545 2.07014 27.2422 2.75783C27.9299 3.44551 28.3174 4.37746 28.32 5.34999V19.83C28.3174 20.8016 27.9295 21.7325 27.2416 22.4186C26.5536 23.1047 25.6216 23.49 24.65 23.49H8.28L4.16 27.61C3.88133 27.8704 3.51127 28.0105 3.13 28ZM5.35 4.17999C5.19683 4.17999 5.04516 4.21032 4.90377 4.26924C4.76238 4.32816 4.63405 4.4145 4.5262 4.52328C4.41836 4.63205 4.33312 4.76111 4.27542 4.90301C4.21771 5.0449 4.18868 5.19682 4.19 5.34999V24.05L7.24 21H24.65C24.8032 21.0013 24.9551 20.9723 25.097 20.9146C25.2389 20.8569 25.3679 20.7716 25.4767 20.6638C25.5855 20.5559 25.6718 20.4276 25.7308 20.2862C25.7897 20.1448 25.82 19.9932 25.82 19.84V5.34999C25.82 5.03969 25.6967 4.7421 25.4773 4.52268C25.2579 4.30326 24.9603 4.17999 24.65 4.17999H5.35ZM11.59 13.31L11.9 11.31H10V10C9.9827 9.84694 10.001 9.69194 10.0535 9.54712C10.1059 9.40229 10.1911 9.27154 10.3025 9.16506C10.4138 9.05859 10.5482 8.97927 10.6952 8.93329C10.8422 8.88731 10.9979 8.87592 11.15 8.9H12V7.15C11.4746 7.05974 10.943 7.0096 10.41 7C10.0473 6.97295 9.683 7.02603 9.34306 7.15548C9.00313 7.28492 8.69582 7.48756 8.44294 7.74903C8.19006 8.0105 7.99779 8.3244 7.87977 8.66847C7.76175 9.01254 7.72086 9.37836 7.76 9.74V11.28H6V13.28H7.76V18.18C8.12352 18.2406 8.49147 18.2707 8.86 18.27C9.24102 18.2835 9.62249 18.2634 10 18.21V13.31H11.59ZM13.98 8.92999H23.98V9.92999H13.98V8.92999ZM22.98 14.93H13.98V15.93H22.98V14.93ZM13.98 11.93H20.98V12.93H13.98V11.93Z" />
		         </svg>
		         ',
		 ),

		 array(
			 'name'   => __( 'Facebook Page', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'facebookpage',
			 'id'     => 37,
			 'icon'   => '
		         <svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
		         <path fill-rule="evenodd" clip-rule="evenodd" d="M29 13.32C29 13.8723 28.5523 14.32 28 14.32H13.4V16.94C13.4 17.4923 12.9523 17.94 12.4 17.94H5.3C4.74772 17.94 4.3 17.4923 4.3 16.94V14.32H2C1.44771 14.32 1 13.8723 1 13.32V2C1 1.44771 1.44772 1 2 1H28C28.5523 1 29 1.44772 29 2V13.32ZM27 12.32H13.4V8.61999C13.4 8.06771 12.9523 7.62 12.4 7.62H5.3C4.74772 7.62 4.3 8.06771 4.3 8.62V12.32H3V4C3 3.44772 3.44772 3 4 3H26C26.5523 3 27 3.44771 27 4V12.32ZM14 9.48001L17.46 4.76001C17.4973 4.71033 17.5456 4.67001 17.6011 4.64224C17.6567 4.61446 17.7179 4.60001 17.78 4.60001C17.8421 4.60001 17.9033 4.61446 17.9589 4.64224C18.0144 4.67001 18.0627 4.71033 18.1 4.76001L20.84 8.46001C20.8532 8.48285 20.8721 8.50183 20.8949 8.51503C20.9177 8.52822 20.9436 8.53517 20.97 8.53517C20.9964 8.53517 21.0223 8.52822 21.0451 8.51503C21.0679 8.50183 21.0868 8.48285 21.1 8.46001L22.83 6.00001C22.8656 5.94637 22.9139 5.90238 22.9706 5.87195C23.0273 5.84151 23.0906 5.82559 23.155 5.82559C23.2194 5.82559 23.2827 5.84151 23.3394 5.87195C23.3961 5.90238 23.4444 5.94637 23.48 6.00001L25.92 9.49001C25.9628 9.55127 25.9886 9.62286 25.9945 9.69739C26.0004 9.77191 25.9864 9.84667 25.9537 9.91394C25.9211 9.98121 25.8711 10.0386 25.809 10.0801C25.7468 10.1216 25.6746 10.1457 25.6 10.15H14.32C14.2437 10.1469 14.1697 10.123 14.106 10.081C14.0422 10.0389 13.9911 9.98028 13.9582 9.91137C13.9253 9.84247 13.9118 9.76589 13.9192 9.68989C13.9265 9.61388 13.9545 9.54132 14 9.48001ZM17 24.29L19.43 21.05C19.4553 21.0187 19.4873 20.9934 19.5236 20.9761C19.56 20.9587 19.5997 20.9497 19.64 20.9497C19.6803 20.9497 19.72 20.9587 19.7564 20.9761C19.7927 20.9934 19.8247 21.0187 19.85 21.05L21.74 23.59C21.749 23.6045 21.7615 23.6164 21.7764 23.6247C21.7912 23.633 21.808 23.6373 21.825 23.6373C21.842 23.6373 21.8588 23.633 21.8736 23.6247C21.8885 23.6164 21.901 23.6045 21.91 23.59L23.1 21.87C23.1246 21.8329 23.1581 21.8024 23.1973 21.7813C23.2366 21.7603 23.2804 21.7493 23.325 21.7493C23.3696 21.7493 23.4134 21.7603 23.4527 21.7813C23.4919 21.8024 23.5254 21.8329 23.55 21.87L25.23 24.3C25.2584 24.3429 25.2749 24.3925 25.2778 24.4439C25.2807 24.4952 25.2699 24.5464 25.2465 24.5922C25.2231 24.638 25.1879 24.6768 25.1446 24.7045C25.1013 24.7322 25.0514 24.7479 25 24.75H17.22C17.1678 24.7474 17.1174 24.7307 17.0739 24.7017C17.0304 24.6728 16.9956 24.6326 16.9731 24.5855C16.9505 24.5384 16.9411 24.4861 16.9459 24.434C16.9506 24.382 16.9693 24.3323 17 24.29ZM12.4 8.62V16.94H5.3V8.62H12.4ZM15 15.93H28V16.92H15V15.93ZM27 18.94V27H16V18.94H27ZM28 18.94C28 18.3877 27.5523 17.94 27 17.94H16C15.4477 17.94 15 18.3877 15 18.94V27C15 27.5523 15.4477 28 16 28H27C27.5523 28 28 27.5523 28 27V18.94ZM4.3 18.93H13.4V19.93H4.3V18.93ZM13.4 20.93H4.3V21.93H13.4V20.93ZM4.3 22.93H13.4V23.93H4.3V22.93ZM13.4 24.93H4.3V25.93H13.4V24.93ZM4.3 26.93H13.4V27.93H4.3V26.93ZM10.13 12.3L10 13.16H9.26V15.25C9.10684 15.2603 8.95316 15.2603 8.8 15.25C8.6435 15.2603 8.4865 15.2603 8.33 15.25V13.16H7.57V12.3H8.33V11.64C8.31327 11.4862 8.33074 11.3306 8.38117 11.1843C8.4316 11.038 8.51374 10.9046 8.62172 10.7938C8.72969 10.683 8.86083 10.5974 9.00575 10.5431C9.15067 10.4889 9.30578 10.4673 9.46 10.48C9.68453 10.483 9.9085 10.5031 10.13 10.54V11.27H9.75C9.68555 11.2625 9.62023 11.2692 9.55871 11.2899C9.4972 11.3106 9.44101 11.3446 9.39418 11.3895C9.34735 11.4344 9.31104 11.4891 9.28784 11.5497C9.26464 11.6103 9.25513 11.6753 9.26 11.74V12.3H10.13Z"/>
		         </svg>',
		 ),

		 array(
			 'name'   => __( 'Facebook Embed', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'adv',
			 'type'   => 'facebookembed',
			 'id'     => 38,
			 'icon'   => '
		 <svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
		 <path fill-rule="evenodd" clip-rule="evenodd" d="M23.6023 7.34992H3.17535V21.4816H11.9735C12.13 21.4816 12.2801 21.5438 12.3908 21.6545C12.5015 21.7651 12.5637 21.9153 12.5637 22.0718V23.2522C12.5637 23.4087 12.5015 23.5588 12.3908 23.6695C12.2801 23.7802 12.13 23.8423 11.9735 23.8423H3.15349C2.52738 23.8423 1.92692 23.5936 1.48419 23.1509C1.04147 22.7082 0.792746 22.1077 0.792746 21.4816V7.34992C0.794172 7.03897 0.857013 6.73137 0.977659 6.44478C1.09831 6.1582 1.27438 5.89827 1.49577 5.67992C1.71716 5.46158 1.97951 5.28912 2.26774 5.17246C2.55597 5.05579 2.86441 4.99722 3.17535 5.0001H23.5805C24.2028 5.00298 24.7988 5.25147 25.2389 5.69152C25.6789 6.13158 25.9274 6.72759 25.9303 7.34992V15.0005C25.9304 15.1533 25.8712 15.3002 25.7652 15.4103C25.6592 15.5203 25.5147 15.585 25.362 15.5907H24.1925C24.036 15.5907 23.8859 15.5285 23.7752 15.4178C23.6645 15.3071 23.6023 15.157 23.6023 15.0005V7.34992ZM29.1873 21.6127V20.6947L28.3238 20.2138L26.2473 19.0771L24.4221 18.0498V19.6127L24.8046 19.7985L27.3402 21.0881L24.6188 22.3232L24.4221 22.4215V23.9626L29.1873 21.6127ZM16.6185 13.9731L11.0882 10.279C11.0056 10.2231 10.9092 10.1909 10.8096 10.1859C10.71 10.1809 10.6109 10.2033 10.5231 10.2506C10.4353 10.2979 10.362 10.3683 10.3114 10.4542C10.2607 10.5401 10.2346 10.6383 10.2357 10.738V18.1044C10.2346 18.2042 10.2607 18.3023 10.3114 18.3882C10.362 18.4742 10.4353 18.5446 10.5231 18.5919C10.6109 18.6392 10.71 18.6615 10.8096 18.6565C10.9092 18.6515 11.0056 18.6193 11.0882 18.5635L16.6185 14.8803C16.6929 14.8303 16.7538 14.7628 16.796 14.6837C16.8381 14.6046 16.8601 14.5163 16.8601 14.4267C16.8601 14.3371 16.8381 14.2488 16.796 14.1697C16.7538 14.0906 16.6929 14.0231 16.6185 13.9731ZM24.0614 17.1098L23.1761 19.7985L22.3564 22.3231L21.482 24.9899H19.8536L20.717 22.3231L21.5476 19.7985L22.422 17.1098H24.0614ZM19.0557 19.7985L16.5201 21.0881L19.2415 22.3232L19.4383 22.4215V23.9626L16.1157 22.3232L14.6621 21.6127V20.6947L16.2906 19.7985L19.4383 18.0498V19.6127L19.0557 19.7985Z" />
		 </svg>
		 ',
		 ),




		 array(
			'name'   => __( 'Custom HTML', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'adv',
			'type'   => 'custom-html',
			'id'     => 20,
			'icon'   => '
	   <svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M9.4 16.6L4.8 12l4.6-4.6L8 6l-6 6 6 6 1.4-1.4zm5.2 0l4.6-4.6-4.6-4.6L16 6l6 6-6 6-1.4-1.4z"/></svg>',
		),
		 array(
			 'name'   => __( 'Add To Cart', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wcaddtocart',
			 'id'     => 34,
			 'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.48 11.69H17.09C17.22 11.69 17.3446 11.6384 17.4365 11.5465C17.5284 11.4546 17.58 11.3299 17.58 11.2V7.71999H21C21.0639 7.72 21.1271 7.70726 21.186 7.68252C21.2449 7.65777 21.2983 7.62152 21.343 7.57588C21.3877 7.53025 21.4228 7.47614 21.4464 7.41675C21.4699 7.35735 21.4813 7.29386 21.48 7.22999V5.55999C21.48 5.43175 21.4298 5.3086 21.34 5.21699C21.2503 5.12538 21.1282 5.07261 21 5.06999H17.58V1.58999C17.5774 1.45912 17.5236 1.3345 17.4301 1.24288C17.3366 1.15127 17.2109 1.09996 17.08 1.09999H15.47C15.4061 1.09866 15.3426 1.11009 15.2832 1.13362C15.2238 1.15714 15.1697 1.19229 15.1241 1.23699C15.0785 1.2817 15.0422 1.33506 15.0175 1.39396C14.9927 1.45286 14.98 1.5161 14.98 1.57999V5.06999H11.58C11.4518 5.06996 11.3286 5.12021 11.237 5.20995C11.1454 5.29969 11.0926 5.42177 11.09 5.54999V7.21999C11.0926 7.35179 11.1461 7.47749 11.2393 7.57071C11.3325 7.66393 11.4582 7.71743 11.59 7.71999H15V11.19C14.9999 11.3192 15.0498 11.4434 15.1393 11.5367C15.2288 11.6299 15.3509 11.6848 15.48 11.69ZM9.8 23.61C9.27349 23.5981 8.75536 23.7433 8.31175 24.0271C7.86814 24.311 7.51916 24.7206 7.30936 25.2036C7.09956 25.6867 7.03844 26.2213 7.13382 26.7392C7.22919 27.2572 7.47673 27.7349 7.84483 28.1116C8.21294 28.4882 8.68492 28.7466 9.20054 28.8538C9.71616 28.961 10.252 28.9122 10.7398 28.7135C11.2275 28.5148 11.645 28.1753 11.9389 27.7383C12.2328 27.3013 12.3899 26.7866 12.39 26.26C12.3953 25.9156 12.3323 25.5735 12.2048 25.2535C12.0773 24.9335 11.8876 24.642 11.6469 24.3956C11.4061 24.1493 11.1189 23.953 10.802 23.8182C10.485 23.6833 10.1445 23.6126 9.8 23.61ZM22.8 23.61C22.2735 23.5981 21.7554 23.7433 21.3118 24.0271C20.8681 24.311 20.5192 24.7206 20.3094 25.2036C20.0996 25.6867 20.0384 26.2213 20.1338 26.7392C20.2292 27.2572 20.4767 27.7349 20.8448 28.1116C21.2129 28.4882 21.6849 28.7466 22.2005 28.8538C22.7162 28.961 23.252 28.9122 23.7398 28.7135C24.2275 28.5148 24.645 28.1753 24.9389 27.7383C25.2328 27.3013 25.3899 26.7866 25.39 26.26C25.394 25.9126 25.3288 25.5678 25.1983 25.2458C25.0678 24.9238 24.8745 24.631 24.6298 24.3844C24.385 24.1378 24.0937 23.9423 23.7727 23.8094C23.4517 23.6764 23.1074 23.6086 22.76 23.61H22.8ZM10 19.3V19.14L11.22 17H20.88C21.3469 16.9984 21.8047 16.8702 22.2044 16.6289C22.6042 16.3876 22.931 16.0424 23.15 15.63L27.92 6.77999C27.9817 6.66553 27.9963 6.53155 27.9608 6.40647C27.9254 6.28139 27.8426 6.17505 27.73 6.10999L26.21 5.25999C26.1521 5.22778 26.0882 5.2079 26.0223 5.2016C25.9563 5.1953 25.8898 5.20272 25.8269 5.22338C25.7639 5.24405 25.706 5.27751 25.6566 5.32167C25.6072 5.36584 25.5675 5.41974 25.54 5.47999L24.46 7.71999L20.88 14.34H11.78L11.61 14L8.71 7.71999L7.48 5.06999L6.39 2.70999C6.35668 2.63132 6.30297 2.56296 6.23442 2.51198C6.16586 2.461 6.08493 2.42924 6 2.41999H2.51C2.4448 2.41997 2.38026 2.43297 2.32015 2.45822C2.26004 2.48347 2.20557 2.52046 2.15993 2.56702C2.1143 2.61359 2.07842 2.66879 2.05439 2.7294C2.03036 2.79001 2.01867 2.8548 2.02 2.91999V4.56999C2.01867 4.63517 2.03036 4.69997 2.05439 4.76058C2.07842 4.82118 2.1143 4.87639 2.15993 4.92295C2.20557 4.96952 2.26004 5.00651 2.32015 5.03176C2.38026 5.057 2.4448 5.07 2.51 5.06999H4.61L9.28 15.07L7.53 18.36C7.26814 18.8355 7.15985 19.3805 7.22 19.92C7.3034 20.5774 7.62564 21.1811 8.12536 21.6163C8.62508 22.0515 9.26739 22.2877 9.93 22.28H24.87C24.9339 22.28 24.9971 22.2673 25.056 22.2425C25.1149 22.2178 25.1683 22.1815 25.213 22.1359C25.2577 22.0902 25.2928 22.0361 25.3164 21.9767C25.3399 21.9174 25.3513 21.8539 25.35 21.79V20.13C25.3513 20.0656 25.34 20.0017 25.3166 19.9417C25.2931 19.8817 25.2582 19.827 25.2136 19.7805C25.169 19.7341 25.1157 19.6969 25.0568 19.6711C24.9978 19.6453 24.9344 19.6313 24.87 19.63H10.34C10.2955 19.6328 10.2508 19.6263 10.209 19.6108C10.1671 19.5954 10.129 19.5713 10.097 19.5403C10.0649 19.5092 10.0398 19.4717 10.0231 19.4304C10.0064 19.389 9.99852 19.3446 10 19.3Z" />
</svg>',
			 ),

		 array(
			 'name'   => __( 'Checkout', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wccheckout',
			 'id'     => 35,
			 'icon'   => '<svg class="sp-w-6 sp-fill-current "   viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M8.90441 23.8719C9.36486 23.5642 9.90621 23.4 10.46 23.4C10.8281 23.3987 11.1928 23.4702 11.5331 23.6104C11.8734 23.7507 12.1826 23.9569 12.4428 24.2172C12.7031 24.4774 12.9093 24.7866 13.0496 25.1269C13.1898 25.4672 13.2613 25.8319 13.26 26.2C13.26 26.7538 13.0958 27.2951 12.7881 27.7556C12.4804 28.2161 12.0431 28.5749 11.5315 28.7869C11.0199 28.9988 10.4569 29.0542 9.91375 28.9462C9.3706 28.8382 8.87169 28.5715 8.4801 28.1799C8.08852 27.7883 7.82184 27.2894 7.7138 26.7463C7.60576 26.2031 7.66121 25.6401 7.87314 25.1285C8.08506 24.6169 8.44395 24.1796 8.90441 23.8719ZM22.9044 23.8719C23.3649 23.5642 23.9062 23.4 24.46 23.4H24.43C24.8002 23.396 25.1675 23.4655 25.5107 23.6045C25.8539 23.7434 26.1661 23.949 26.4293 24.2094C26.6925 24.4698 26.9014 24.7798 27.044 25.1215C27.1866 25.4632 27.26 25.8298 27.26 26.2C27.26 26.7538 27.0958 27.2951 26.7881 27.7556C26.4804 28.2161 26.0431 28.5749 25.5315 28.7869C25.0199 28.9988 24.4569 29.0542 23.9137 28.9462C23.3706 28.8382 22.8717 28.5715 22.4801 28.1799C22.0885 27.7883 21.8218 27.2894 21.7138 26.7463C21.6058 26.2031 21.6612 25.6401 21.8731 25.1285C22.0851 24.6169 22.4439 24.1796 22.9044 23.8719ZM23.9752 11.3809L25.26 7.43C25.2955 7.32386 25.2881 7.20807 25.2396 7.10724C25.191 7.00641 25.1051 6.92848 25 6.89L13.85 3.27C13.7426 3.23505 13.6257 3.24377 13.5246 3.2943C13.4236 3.34482 13.3465 3.43308 13.31 3.54L11.18 10.09C11.1613 10.1431 11.1535 10.1995 11.157 10.2557C11.1605 10.3119 11.1753 10.3669 11.2005 10.4172C11.2257 10.4676 11.2608 10.5124 11.3036 10.549C11.3465 10.5855 11.3963 10.6131 11.45 10.63L20.5645 13.6H12.6L12.42 13.22L9.29 6.6L8 3.8L6.79 1.3C6.74823 1.21053 6.68184 1.13481 6.59861 1.08168C6.51538 1.02855 6.41874 1.00022 6.32 1H2.61C2.46944 1 2.33463 1.05584 2.23524 1.15523C2.13584 1.25463 2.08 1.38944 2.08 1.53V3.28C2.07999 3.34914 2.09376 3.41758 2.12052 3.48133C2.14727 3.54508 2.18647 3.60286 2.23582 3.65128C2.28518 3.6997 2.34369 3.73779 2.40793 3.76332C2.47218 3.78886 2.54088 3.80133 2.61 3.8H4.88L9.88 14.43L8 17.86C7.71649 18.357 7.60077 18.9321 7.67 19.5C7.76359 20.2049 8.11465 20.8503 8.6556 21.3119C9.19656 21.7734 9.88914 22.0185 10.6 22H26.7C26.8406 22 26.9754 21.9442 27.0748 21.8448C27.1742 21.7454 27.23 21.6106 27.23 21.47V19.72C27.23 19.6509 27.2162 19.5824 27.1895 19.5187C27.1627 19.4549 27.1235 19.3971 27.0742 19.3487C27.0248 19.3003 26.9663 19.2622 26.9021 19.2367C26.8378 19.2111 26.7691 19.1987 26.7 19.2H11.05C10.9572 19.2 10.8682 19.1631 10.8025 19.0975C10.7369 19.0318 10.7 18.9428 10.7 18.85V18.68L12 16.4H22.41C22.9047 16.4058 23.3919 16.279 23.8209 16.0328C24.25 15.7866 24.6054 15.43 24.85 15L27.85 10.89C27.8833 10.8297 27.9043 10.7634 27.9118 10.6949C27.9192 10.6264 27.913 10.5571 27.8935 10.4911C27.8739 10.425 27.8415 10.3635 27.798 10.3101C27.7544 10.2567 27.7008 10.2125 27.64 10.18L26 9.24C25.9381 9.2058 25.8698 9.18461 25.7994 9.17771C25.7289 9.17082 25.6579 9.17837 25.5905 9.1999C25.5231 9.22143 25.4608 9.25649 25.4074 9.30293C25.354 9.34938 25.3107 9.40623 25.28 9.47L23.9752 11.3809ZM22.45 13.31L24.31 7.58L14 4.22L12.13 10L22.45 13.31ZM21.49 8.9C21.5728 8.92615 21.6496 8.96839 21.7161 9.02429C21.7825 9.08019 21.8373 9.14865 21.8773 9.22576C21.9172 9.30286 21.9415 9.38709 21.9489 9.47362C21.9562 9.56015 21.9464 9.64727 21.92 9.73C21.863 9.89385 21.7446 10.0292 21.5898 10.1075C21.435 10.1858 21.2558 10.2011 21.09 10.15C21.0489 10.137 21.0092 10.1201 20.9716 10.0994C21.1255 9.93458 21.2415 9.73681 21.31 9.52C21.3718 9.32899 21.3948 9.12758 21.3778 8.92756C21.3762 8.90889 21.3743 8.89026 21.372 8.87169C21.412 8.87741 21.4515 8.88687 21.49 8.9ZM20.9954 8.0451C21.2484 7.99146 21.5117 8.00314 21.76 8.08C21.9514 8.13924 22.1292 8.23573 22.2832 8.36393C22.4372 8.49214 22.5643 8.64952 22.6572 8.82703C22.7502 9.00453 22.8071 9.19867 22.8247 9.39825C22.8424 9.59784 22.8204 9.79894 22.76 9.99C22.6695 10.2763 22.4963 10.5294 22.2622 10.7173C22.0281 10.9053 21.7435 11.0197 21.4444 11.0462C21.1453 11.0726 20.8451 11.0098 20.5817 10.8659C20.43 10.783 20.2944 10.6753 20.1801 10.5481C20.1191 10.5612 20.0571 10.5706 19.9944 10.5762C19.6953 10.6026 19.3951 10.5398 19.1317 10.3959C18.8682 10.2519 18.6533 10.0331 18.514 9.76708C18.3748 9.50109 18.3174 9.19981 18.3492 8.90125C18.3809 8.60269 18.5004 8.32022 18.6925 8.08948C18.8846 7.85874 19.1408 7.69007 19.4286 7.60474C19.7165 7.5194 20.0232 7.52123 20.31 7.61C20.5022 7.66806 20.6808 7.76386 20.8355 7.89179C20.8926 7.93902 20.946 7.99028 20.9954 8.0451ZM20.1964 8.49823C20.1508 8.46973 20.1017 8.44675 20.05 8.43C19.968 8.402 19.8812 8.39069 19.7947 8.39673C19.7083 8.40277 19.6239 8.42604 19.5465 8.46517C19.4692 8.50431 19.4005 8.55851 19.3444 8.6246C19.2883 8.69069 19.246 8.76732 19.22 8.85C19.1788 8.97408 19.1754 9.10758 19.2103 9.23359C19.2451 9.35959 19.3165 9.47242 19.4156 9.55776C19.5146 9.64311 19.6367 9.69712 19.7665 9.71296C19.7783 9.71439 19.79 9.71551 19.8018 9.71631C19.7879 9.60234 19.7869 9.48659 19.7992 9.37125C19.8309 9.07269 19.9504 8.79022 20.1425 8.55948C20.1599 8.53855 20.1779 8.51813 20.1964 8.49823ZM16.29 6.75L14.7 6.23C14.5846 6.19544 14.4603 6.20749 14.3537 6.26359C14.2472 6.31968 14.1668 6.41533 14.13 6.53C14.1113 6.58646 14.104 6.64606 14.1085 6.70536C14.113 6.76466 14.1292 6.82248 14.1561 6.87548C14.1831 6.92849 14.2203 6.97562 14.2656 7.01416C14.3109 7.05269 14.3634 7.08187 14.42 7.1L16 7.62C16.1154 7.65541 16.24 7.64504 16.348 7.59105C16.456 7.53706 16.5391 7.44358 16.58 7.33C16.6149 7.2133 16.6031 7.0876 16.5472 6.9794C16.4912 6.8712 16.3954 6.78896 16.28 6.75H16.29ZM14.16 7.89999L16.58 8.67999C16.6828 8.72665 16.7648 8.80947 16.8105 8.9127C16.8562 9.01592 16.8623 9.13233 16.8277 9.23978C16.7932 9.34723 16.7203 9.43822 16.623 9.49542C16.5257 9.55262 16.4107 9.57204 16.3 9.54999L13.88 8.75999C13.8235 8.74161 13.7712 8.71228 13.7261 8.67369C13.681 8.63509 13.6439 8.58798 13.617 8.53506C13.59 8.48213 13.5738 8.42441 13.5692 8.3652C13.5645 8.306 13.5716 8.24646 13.59 8.18999C13.6084 8.13352 13.6377 8.08123 13.6763 8.0361C13.7149 7.99096 13.762 7.95387 13.8149 7.92694C13.8679 7.90001 13.9256 7.88377 13.9848 7.87915C14.044 7.87453 14.1035 7.88161 14.16 7.89999Z" />
</svg>
',
		 ),

		 array(
			 'name'   => __( 'Cart', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wccart',
			 'id'     => 36,
			 'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M23.37 23.33C22.8166 23.332 22.2763 23.4979 21.8171 23.8067C21.358 24.1156 21.0007 24.5536 20.7903 25.0654C20.5799 25.5772 20.5259 26.1399 20.635 26.6824C20.7442 27.2248 21.0117 27.7228 21.4036 28.1134C21.7956 28.504 22.2945 28.7697 22.8374 28.8769C23.3803 28.9841 23.9428 28.9281 24.4538 28.7159C24.9649 28.5037 25.4016 28.1448 25.7088 27.6846C26.016 27.2243 26.18 26.6834 26.18 26.13C26.1813 25.7611 26.1095 25.3956 25.9686 25.0546C25.8277 24.7136 25.6207 24.404 25.3593 24.1436C25.098 23.8832 24.7876 23.6772 24.4461 23.5375C24.1047 23.3979 23.7389 23.3274 23.37 23.33ZM9.37 23.33C8.81621 23.33 8.27486 23.4942 7.8144 23.8019C7.35395 24.1096 6.99506 24.5469 6.78314 25.0585C6.57121 25.5701 6.51576 26.1331 6.6238 26.6762C6.73184 27.2194 6.99851 27.7183 7.3901 28.1099C7.78169 28.5015 8.2806 28.7682 8.82375 28.8762C9.36689 28.9842 9.92988 28.9288 10.4415 28.7169C10.9531 28.5049 11.3904 28.1461 11.6981 27.6856C12.0058 27.2251 12.17 26.6838 12.17 26.13C12.1713 25.7636 12.1005 25.4005 11.9615 25.0615C11.8225 24.7225 11.6181 24.4142 11.3599 24.1542C11.1018 23.8942 10.7949 23.6876 10.4569 23.5462C10.1189 23.4048 9.75639 23.3313 9.39 23.33H9.37Z" />
        <path d="M29 4.70999V5.18999C29.016 5.27592 29.016 5.36406 29 5.44999C28.9861 5.49589 28.9659 5.53963 28.94 5.57999C28.9206 5.62532 28.8972 5.66883 28.87 5.70999L23.82 14.88C23.5806 15.3174 23.2275 15.6821 22.798 15.9356C22.3686 16.189 21.8787 16.3218 21.38 16.32H11H10.94L9.67 18.61L9.62 18.78C9.6226 18.8737 9.66168 18.9627 9.72891 19.0281C9.79615 19.0935 9.88623 19.13 9.98 19.13H25.65C25.7906 19.13 25.9254 19.1858 26.0248 19.2852C26.1242 19.3846 26.18 19.5194 26.18 19.66V21.4C26.18 21.5406 26.1242 21.6754 26.0248 21.7748C25.9254 21.8742 25.7906 21.93 25.65 21.93H9.53C8.82028 21.9441 8.13004 21.6974 7.59003 21.2367C7.05003 20.7759 6.69777 20.1331 6.6 19.43C6.54061 18.8581 6.65936 18.2818 6.94 17.78L8.81 14.38V14.33L3.8 3.75999H1.52C1.44865 3.75876 1.37828 3.74313 1.31311 3.71404C1.24794 3.68496 1.18932 3.64301 1.14076 3.59071C1.09221 3.53842 1.05471 3.47685 1.03052 3.40971C1.00633 3.34257 0.99595 3.27124 1 3.19999V1.45999C0.999975 1.32114 1.05444 1.18783 1.15168 1.08872C1.24892 0.989606 1.38118 0.932612 1.52 0.929993H5.18C5.29158 0.930348 5.40093 0.961303 5.49614 1.01949C5.59135 1.07767 5.66878 1.16086 5.72 1.25999L6.88 3.72999L8.21 6.52999L11.35 13.16L11.53 13.53H21.32H21.37L25.21 6.52999L25.41 6.11999H13.41C13.3404 6.12132 13.2712 6.10892 13.2064 6.0835C13.1416 6.05808 13.0824 6.02015 13.0323 5.97186C12.9821 5.92357 12.942 5.86587 12.9141 5.80207C12.8863 5.73826 12.8713 5.6696 12.87 5.59999V4.18999C12.8713 4.12039 12.8863 4.05172 12.9141 3.98792C12.942 3.92411 12.9821 3.86642 13.0323 3.81813C13.0824 3.76984 13.1416 3.7319 13.2064 3.70648C13.2712 3.68107 13.3404 3.66867 13.41 3.66999H27.93C28.2094 3.66731 28.4786 3.77507 28.679 3.96983C28.8794 4.16459 28.9947 4.4306 29 4.70999Z" />
        </svg>
        ',
		 ),

		 array(
			 'name'   => __( 'Products Grid', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wccustomproductsgrid',
			 'id'     => 37,
			 'icon'   => '
        <svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M16.44 8.50999H23.65V11.39H16.44V8.50999ZM16.44 18.61H23.65V21.49H16.44V18.61ZM25.1 1.99999H4.9C4.5188 1.99867 4.1411 2.07277 3.78866 2.21804C3.43622 2.36332 3.116 2.57688 2.84645 2.84643C2.57689 3.11598 2.36333 3.4362 2.21806 3.78864C2.07279 4.14108 1.99868 4.51878 2 4.89999V25.1C1.99868 25.4812 2.07279 25.8589 2.21806 26.2113C2.36333 26.5638 2.57689 26.884 2.84645 27.1535C3.116 27.4231 3.43622 27.6367 3.78866 27.7819C4.1411 27.9272 4.5188 28.0013 4.9 28H25.1C25.4812 28.0013 25.8589 27.9272 26.2113 27.7819C26.5638 27.6367 26.884 27.4231 27.1536 27.1535C27.4231 26.884 27.6367 26.5638 27.7819 26.2113C27.9272 25.8589 28.0013 25.4812 28 25.1V4.89999C28.0013 4.51878 27.9272 4.14108 27.7819 3.78864C27.6367 3.4362 27.4231 3.11598 27.1536 2.84643C26.884 2.57688 26.5638 2.36332 26.2113 2.21804C25.8589 2.07277 25.4812 1.99867 25.1 1.99999ZM25.1 25.08H4.9V4.89999H25.1V25.08ZM13.56 6.34999H6.35V13.56H13.56V6.34999ZM12.12 12.12H7.79V7.78999H12.12V12.12ZM13.56 16.44H6.35V23.65H13.56V16.44ZM12.12 22.21H7.79V17.88H12.12V22.21Z" />
        </svg>',
		 ),

		 array(
			 'name'   => __( 'Recent Products', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wcrecentproductsgrid',
			 'id'     => 42,
			 'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M13.56 9.23V16.44L19.69 20.08L20.8 18.23L15.72 15.23V9.23H13.56ZM28 12.12V2L24.17 5.83C22.0377 3.70809 19.2355 2.39134 16.2411 2.10417C13.2467 1.817 10.2453 2.57719 7.74859 4.25518C5.25189 5.93316 3.41438 8.42507 2.54927 11.3062C1.68416 14.1873 1.84499 17.2792 3.00434 20.055C4.1637 22.8308 6.24982 25.1186 8.90714 26.5285C11.5645 27.9384 14.6285 28.3831 17.577 27.7868C20.5255 27.1906 23.1759 25.5902 25.0765 23.2585C26.9772 20.9268 28.0104 18.0082 28 15H25.1C25.111 17.3387 24.3109 19.6088 22.8359 21.4237C21.361 23.2387 19.3024 24.4861 17.0109 24.9536C14.7195 25.421 12.3368 25.0796 10.2688 23.9875C8.20076 22.8953 6.57536 21.1199 5.66944 18.9639C4.76351 16.8078 4.6331 14.4043 5.30043 12.1628C5.96775 9.92135 7.39152 7.98057 9.32922 6.67107C11.2669 5.36156 13.5987 4.76434 15.9273 4.98113C18.2559 5.19792 20.4373 6.21531 22.1 7.86L17.84 12.12H28Z" />
        </svg>',
		 ),

		 array(
			 'name'   => __( 'Sale Products', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wcsaleproductsgrid',
			 'id'     => 40,
			 'icon'   => '
        <svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15 4.3C17.1163 4.3 19.185 4.92754 20.9446 6.10328C22.7042 7.27901 24.0757 8.95012 24.8855 10.9053C25.6954 12.8605 25.9073 15.0119 25.4944 17.0875C25.0815 19.1631 24.0625 21.0696 22.566 22.566C21.0696 24.0625 19.1631 25.0815 17.0875 25.4944C15.0119 25.9073 12.8605 25.6954 10.9053 24.8855C8.95012 24.0757 7.27901 22.7042 6.10328 20.9446C4.92755 19.185 4.30001 17.1163 4.30001 15C4.30265 12.163 5.43082 9.44295 7.43689 7.43688C9.44295 5.43082 12.163 4.30265 15 4.3ZM15 2C12.4288 2 9.91543 2.76244 7.77759 4.1909C5.63975 5.61935 3.97351 7.64968 2.98957 10.0251C2.00563 12.4006 1.74819 15.0144 2.2498 17.5362C2.75141 20.0579 3.98953 22.3743 5.80762 24.1924C7.6257 26.0105 9.94208 27.2486 12.4638 27.7502C14.9856 28.2518 17.5995 27.9944 19.9749 27.0104C22.3503 26.0265 24.3807 24.3603 25.8091 22.2224C27.2376 20.0846 28 17.5712 28 15C28 11.5522 26.6304 8.24558 24.1924 5.80761C21.7544 3.36964 18.4478 2 15 2ZM6.23 17.16V15.91C6.44916 16.0962 6.69975 16.2418 6.97 16.34C7.22889 16.4379 7.50322 16.4887 7.78 16.49C7.91827 16.4914 8.05611 16.4745 8.19 16.44C8.29585 16.4165 8.39717 16.376 8.49 16.32C8.56399 16.2758 8.62584 16.214 8.67 16.14C8.7216 16.065 8.74923 15.9761 8.74923 15.885C8.74923 15.7939 8.7216 15.705 8.67 15.63C8.60472 15.5331 8.51948 15.4513 8.42 15.39C8.2992 15.3041 8.1682 15.2336 8.03 15.18L7.55 14.97C7.16689 14.8318 6.82353 14.6018 6.55 14.3C6.3687 14.0587 6.25934 13.771 6.23457 13.4702C6.2098 13.1694 6.27062 12.8677 6.41 12.6C6.51312 12.3853 6.67199 12.2023 6.87 12.07C7.0811 11.9245 7.31906 11.8225 7.57 11.77C7.84529 11.7048 8.12711 11.6713 8.41 11.67C8.67124 11.6677 8.93219 11.6878 9.19 11.73C9.40179 11.7611 9.60964 11.8147 9.81 11.89V13.07C9.71588 12.998 9.61135 12.9406 9.5 12.9C9.39086 12.8464 9.27705 12.8029 9.16 12.77L8.81 12.7C8.70022 12.6903 8.58979 12.6903 8.48 12.7C8.35048 12.6842 8.21952 12.6842 8.09 12.7C7.98376 12.7166 7.88182 12.754 7.79 12.81C7.71602 12.8542 7.65416 12.916 7.61 12.99C7.56303 13.0574 7.53854 13.1379 7.54 13.22C7.53564 13.3087 7.56021 13.3965 7.61 13.47C7.66638 13.5552 7.73749 13.6297 7.82 13.69C7.92967 13.7597 8.04318 13.8231 8.16 13.88L8.6 14.08C8.80768 14.1638 9.00832 14.2642 9.2 14.38C9.36895 14.4746 9.52379 14.5924 9.66 14.73C9.78755 14.8615 9.88631 15.0182 9.95 15.19C10.0221 15.3816 10.0561 15.5854 10.05 15.79C10.0624 16.0604 10.0038 16.3293 9.88 16.57C9.76295 16.7818 9.59443 16.9606 9.39 17.09C9.17547 17.2248 8.93832 17.3197 8.69 17.37C8.40743 17.431 8.11908 17.4612 7.83 17.46C7.53817 17.46 7.24695 17.4332 6.96 17.38C6.70689 17.3443 6.46072 17.2701 6.23 17.16ZM14.53 17.38H15.9L13.88 11.78H12.38L10.38 17.38H11.73L12.13 16.13H14.13L14.53 17.38ZM13.24 13.28L13.84 15.16H12.44L13.05 13.27C13.0984 13.1106 13.1286 12.9462 13.14 12.78C13.1539 12.95 13.1875 13.1177 13.24 13.28ZM19.94 17.38H16.6V11.78H17.86V16.36H19.94V17.38ZM20.69 17.38H24.08V16.36H21.95V15.07H23.76V14.07H21.92V12.78H23.92V11.78H20.69V17.38Z" />
        </svg>',
		 ),

		 array(
			 'name'   => __( 'Best Selling Products', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wcbestsellingproductsgrid',
			 'id'     => 41,
			 'icon'   => '
<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zM7 10h2v7H7zm4-3h2v10h-2zm4 6h2v4h-2z"/></svg> ',
		 ),

		 array(
			 'name'   => __( 'Featured Products', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wcfeaturedproductsgrid',
			 'id'     => 39,
			 'icon'   => ' <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><rect fill="none" height="24" width="24"/><path d="M19,5h-2V3H7v2H5C3.9,5,3,5.9,3,7v1c0,2.55,1.92,4.63,4.39,4.94c0.63,1.5,1.98,2.63,3.61,2.96V19H7v2h10v-2h-4v-3.1 c1.63-0.33,2.98-1.46,3.61-2.96C19.08,12.63,21,10.55,21,8V7C21,5.9,20.1,5,19,5z M5,8V7h2v3.82C5.84,10.4,5,9.3,5,8z M12,14 c-1.65,0-3-1.35-3-3V5h6v6C15,12.65,13.65,14,12,14z M19,8c0,1.3-0.84,2.4-2,2.82V7h2V8z"/></svg>',
		 ),

		 array(
			 'name'   => __( 'Top Rated Products', 'coming-soon' ),
			 'is_pro' => true,
			 'cat'    => 'wc',
			 'type'   => 'wctopratedproductsgrid',
			 'id'     => 43,
			 'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" class="sp-w-6 sp-fill-current " viewBox="0 0 24 24" ><g><rect fill="none" height="24" width="24"/></g><g><g><path d="M17,10.43V2H7v8.43c0,0.35,0.18,0.68,0.49,0.86l4.18,2.51l-0.99,2.34l-3.41,0.29l2.59,2.24L9.07,22L12,20.23L14.93,22 l-0.78-3.33l2.59-2.24l-3.41-0.29l-0.99-2.34l4.18-2.51C16.82,11.11,17,10.79,17,10.43z M11,11.07l-2-1.2V4h2V11.07z M15,9.87 l-2,1.2V4h2V9.87z"/></g></g></svg>',
		 ),

	 );

	 return $block_options;
}


/**
* Get times
*/
function seedprod_lite_get_default_timezone() {
	$general_settings = get_option( 'seedprod_settings' );
	$timezone         = 'UTC';

	if ( ! empty( $general_settings ) ) {
		$general_settings = json_decode( $general_settings );
		if ( ! empty( $general_settings->default_timezone ) ) {
			$timezone = $general_settings->default_timezone;
		}
	}

	return $timezone;
}



/**
* Get times
*/
function seedprod_lite_get_times() {
	 $times  = array();
	$times[] = array(
		'v' => '',
		'l' => __( 'Select Time', 'coming-soon' ),
	);
	$times[] = array(
		'v' => '00:00',
		'l' => '12:00 A.M.',
	);
	$times[] = array(
		'v' => '00:30',
		'l' => '12:30 A.M.',
	);
	$times[] = array(
		'v' => '01:00',
		'l' => '1:00 A.M.',
	);
	$times[] = array(
		'v' => '01:30',
		'l' => '1:30 A.M.',
	);
	$times[] = array(
		'v' => '02:00',
		'l' => '2:00 A.M.',
	);
	$times[] = array(
		'v' => '02:30',
		'l' => '2:30 A.M.',
	);
	$times[] = array(
		'v' => '03:00',
		'l' => '3:00 A.M.',
	);
	$times[] = array(
		'v' => '03:30',
		'l' => '3:30 A.M.',
	);
	$times[] = array(
		'v' => '04:00',
		'l' => '4:00 A.M.',
	);
	$times[] = array(
		'v' => '04:30',
		'l' => '4:30 A.M.',
	);
	$times[] = array(
		'v' => '05:00',
		'l' => '5:00 A.M.',
	);
	$times[] = array(
		'v' => '05:30',
		'l' => '5:30 A.M.',
	);
	$times[] = array(
		'v' => '06:00',
		'l' => '6:00 A.M.',
	);
	$times[] = array(
		'v' => '06:30',
		'l' => '6:30 A.M.',
	);
	$times[] = array(
		'v' => '07:00',
		'l' => '7:00 A.M.',
	);
	$times[] = array(
		'v' => '07:30',
		'l' => '7:30 A.M.',
	);
	$times[] = array(
		'v' => '08:00',
		'l' => '8:00 A.M.',
	);
	$times[] = array(
		'v' => '08:30',
		'l' => '8:30 A.M.',
	);
	$times[] = array(
		'v' => '09:00',
		'l' => '9:00 A.M.',
	);
	$times[] = array(
		'v' => '09:30',
		'l' => '9:30 A.M.',
	);
	$times[] = array(
		'v' => '10:00',
		'l' => '10:00 A.M.',
	);
	$times[] = array(
		'v' => '10:30',
		'l' => '10:30 A.M.',
	);
	$times[] = array(
		'v' => '11:00',
		'l' => '11:00 A.M.',
	);
	$times[] = array(
		'v' => '11:30',
		'l' => '11:30 A.M.',
	);
	$times[] = array(
		'v' => '12:00',
		'l' => '12:00 P.M.',
	);
	$times[] = array(
		'v' => '12:30',
		'l' => '12:30 P.M.',
	);
	$times[] = array(
		'v' => '13:00',
		'l' => '1:00 P.M.',
	);
	$times[] = array(
		'v' => '13:30',
		'l' => '1:30 P.M.',
	);
	$times[] = array(
		'v' => '14:00',
		'l' => '2:00 P.M.',
	);
	$times[] = array(
		'v' => '14:30',
		'l' => '2:30 P.M.',
	);
	$times[] = array(
		'v' => '15:00',
		'l' => '3:00 P.M.',
	);
	$times[] = array(
		'v' => '15:30',
		'l' => '3:30 P.M.',
	);
	$times[] = array(
		'v' => '16:00',
		'l' => '4:00 P.M.',
	);
	$times[] = array(
		'v' => '16:30',
		'l' => '4:30 P.M.',
	);
	$times[] = array(
		'v' => '17:00',
		'l' => '5:00 P.M.',
	);
	$times[] = array(
		'v' => '17:30',
		'l' => '5:30 P.M.',
	);
	$times[] = array(
		'v' => '18:00',
		'l' => '6:00 P.M.',
	);
	$times[] = array(
		'v' => '18:30',
		'l' => '6:30 P.M.',
	);
	$times[] = array(
		'v' => '19:00',
		'l' => '7:00 P.M.',
	);
	$times[] = array(
		'v' => '19:30',
		'l' => '7:30 P.M.',
	);
	$times[] = array(
		'v' => '20:00',
		'l' => '8:00 P.M.',
	);
	$times[] = array(
		'v' => '20:30',
		'l' => '8:30 P.M.',
	);
	$times[] = array(
		'v' => '21:00',
		'l' => '9:00 P.M.',
	);
	$times[] = array(
		'v' => '21:30',
		'l' => '9:30 P.M.',
	);
	$times[] = array(
		'v' => '22:00',
		'l' => '10:00 P.M.',
	);
	$times[] = array(
		'v' => '22:30',
		'l' => '10:30 P.M.',
	);
	$times[] = array(
		'v' => '23:00',
		'l' => '11:00 P.M.',
	);
	$times[] = array(
		'v' => '23:30',
		'l' => '11:30 P.M.',
	);

	return $times;
}

/**
* Check per
*/
function seedprod_lite_get_api_key() {
	$seedprod_api_key = '';

	if ( defined( 'SEEDPROD_API_KEY' ) ) {
		$seedprod_api_key = SEEDPROD_API_KEY;
	}

	if ( empty( $seedprod_api_key ) ) {
		$seedprod_api_key = get_option( 'seedprod_api_key ' );
	}

	return $seedprod_api_key;
}

/**
* Get timezones
*/
function seedprod_lite_get_timezones() {
	 // timezones
	$zonen      = array();
	$continents = array( 'Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe', 'Indian', 'Pacific' );

	foreach ( timezone_identifiers_list() as $zone ) {
		$zone = explode( '/', $zone );
		if ( ! in_array( $zone[0], $continents ) ) {
			continue;
		}

		// This determines what gets set and translated - we don't translate Etc/* strings here, they are done later
		$exists    = array(
			0 => ( isset( $zone[0] ) && $zone[0] ),
			1 => ( isset( $zone[1] ) && $zone[1] ),
			2 => ( isset( $zone[2] ) && $zone[2] ),
		);
		$exists[3] = ( $exists[0] && 'Etc' !== $zone[0] );
		$exists[4] = ( $exists[1] && $exists[3] );
		$exists[5] = ( $exists[2] && $exists[3] );

		$zonen[] = array(
			'continent'   => ( $exists[0] ? $zone[0] : '' ),
			'city'        => ( $exists[1] ? $zone[1] : '' ),
			'subcity'     => ( $exists[2] ? $zone[2] : '' ),
			't_continent' => ( $exists[3] ? translate( str_replace( '_', ' ', $zone[0] ), 'continents-cities' ) : '' ),
			't_city'      => ( $exists[4] ? translate( str_replace( '_', ' ', $zone[1] ), 'continents-cities' ) : '' ),
			't_subcity'   => ( $exists[5] ? translate( str_replace( '_', ' ', $zone[2] ), 'continents-cities' ) : '' ),
		);
	}
	usort( $zonen, '_wp_timezone_choice_usort_callback' );

	$structure = array();

	foreach ( $zonen as $key => $zone ) {
		// Build value in an array to join later
		$value = array( $zone['continent'] );

		if ( empty( $zone['city'] ) ) {
			// It's at the continent level (generally won't happen)
			$display = $zone['t_continent'];
		} else {
			// It's inside a continent group

			// Continent optgroup
			if ( ! isset( $zonen[ $key - 1 ] ) || $zonen[ $key - 1 ]['continent'] !== $zone['continent'] ) {
				$label = $zone['t_continent'];
				//$structure[] = $label ;
			}

			// Add the city to the value
			$value[] = $zone['city'];

			// get offset
			// $timezone = $label.'/'.str_replace(' ', '_', $zone['t_city']);
			// $time = new \DateTime('now', new DateTimeZone($timezone));
			// $timezoneOffset = $time->format('P');

			$display = $zone['t_city'];
			if ( ! empty( $zone['subcity'] ) ) {
				// Add the subcity to the value
				$value[]  = $zone['subcity'];
				$display .= ' - ' . $zone['t_subcity'];
			}
		}

		// Build the value
		$value = join( '/', $value );

		// get offset
		$time                  = new \DateTime( 'now', new DateTimeZone( $value ) );
		$timezoneOffset        = $time->format( 'P' );
		$structure[ $label ][] = array(
			'v' => $value,
			'l' => $display . ' (' . $timezoneOffset . ' GMT)',
		);
	}

	$structure['UTC'][] = array(
		'v' => 'UTC',
		'l' => 'UTC',
	);

	return $structure;
}


/**
* Add to array if value does not exist
*/
function seedprod_lite_array_add( $arr, $key, $value ) {
	if ( ! array_key_exists( $key, $arr ) ) {
		$arr[ $key ] = $value;
	}
	return $arr;
}




/**
* Check per
*/
function seedprod_lite_cu( $rper = null ) {
	if ( ! empty( $rper ) ) {
		$uper = explode( ',', get_option( 'seedprod_per' ) );
		if ( in_array( $rper, $uper ) ) {
			return true;
		} else {
			return false;
		}
	} else {
		$a = get_option( 'seedprod_a' );
		if ( $a ) {
			return true;
		} else {
			return false;
		}
	}
}


function seedprod_lite_upgrade_link( $medium = 'link' ) {
	return apply_filters( 'seedprod_lite_upgrade_link', 'https://seedprod.com/lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=' . sanitize_key( apply_filters( 'seedprod_lite_upgrade_link_medium', $medium ) ) );
}


function seedprod_lite_disable_admin_notices() {
	 global $wp_filter;
	if ( is_user_admin() ) {
		if ( isset( $wp_filter['user_admin_notices'] ) ) {
			unset( $wp_filter['user_admin_notices'] );
		}
	} elseif ( isset( $wp_filter['admin_notices'] ) ) {
		unset( $wp_filter['admin_notices'] );
	}
	if ( isset( $wp_filter['all_admin_notices'] ) ) {
		unset( $wp_filter['all_admin_notices'] );
	}
}
if ( ! empty( $_GET['page'] ) && strpos( $_GET['page'], 'seedprod' ) !== false ) {
	add_action( 'admin_print_scripts', 'seedprod_lite_disable_admin_notices' );
}


function seedprod_lite_plugin_nonce() {
	check_ajax_referer( 'seedprod_lite_plugin_nonce', 'nonce' );

	if ( ! current_user_can( 'install_plugins' ) ) {
		wp_send_json_error();
	}

	$install_plugin_nonce = wp_create_nonce( 'install-plugin_' . sanitize_text_field( $_POST['plugin'] ) );

	wp_send_json( $install_plugin_nonce );
}

function seedprod_lite_is_dev_url( $url = '' ) {
	$is_local_url = false;
	// Trim it up
	$url = strtolower( trim( $url ) );
	// Need to get the host...so let's add the scheme so we can use parse_url
	if ( false === strpos( $url, 'http://' ) && false === strpos( $url, 'https://' ) ) {
		$url = 'http://' . $url;
	}
	$url_parts = parse_url( $url );
	$host      = ! empty( $url_parts['host'] ) ? $url_parts['host'] : false;
	if ( ! empty( $url ) && ! empty( $host ) ) {
		if ( false !== ip2long( $host ) ) {
			if ( ! filter_var( $host, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) ) {
				$is_local_url = true;
			}
		} elseif ( 'localhost' === $host ) {
			$is_local_url = true;
		}

		$tlds_to_check = array( '.local', ':8888', ':8080', ':8081', '.invalid', '.example', '.test' );
		foreach ( $tlds_to_check as $tld ) {
			if ( false !== strpos( $host, $tld ) ) {
				$is_local_url = true;
				break;
			}
		}
		if ( substr_count( $host, '.' ) > 1 ) {
			$subdomains_to_check = array( 'dev.', '*.staging.', 'beta.', 'test.' );
			foreach ( $subdomains_to_check as $subdomain ) {
				$subdomain = str_replace( '.', '(.)', $subdomain );
				$subdomain = str_replace( array( '*', '(.)' ), '(.*)', $subdomain );
				if ( preg_match( '/^(' . $subdomain . ')/', $host ) ) {
					$is_local_url = true;
					break;
				}
			}
		}
	}
	return $is_local_url;
}


function seedprod_lite_find_fonts_in_doc( $someArray ) {
	if ( empty( $someArray ) ) {
		return false;
	}
	$load_fonts    = array();
	$load_variants = array();
	$iterator      = new RecursiveIteratorIterator( new RecursiveArrayIterator( $someArray ), RecursiveIteratorIterator::SELF_FIRST );
	foreach ( $iterator as $k => $v ) {
		$indent = str_repeat( '&nbsp;', 10 * $iterator->getDepth() );
		// Not at end: show key only
		if ( $iterator->hasChildren() ) {
			//echo "$indent$k :<br>";
			// At end: show key, value and path
		} else {
			for ( $p = array(), $i = 0, $z = $iterator->getDepth(); $i <= $z; $i++ ) {
				$p[] = $iterator->getSubIterator( $i )->key();
			}
			$path = implode( ',', $p );
			//echo "$indent$k : $v : path -> $path<br>";
			// get font
			if ( stripos( $k, 'font' ) !== false && stripos( $k, 'variant' ) === false && ! empty( $v ) && strpos( $v, ',' ) === false && stripos( $k, 'fontSize' ) === false ) {
				$load_fonts[] = array(
					'k' => $k,
					'v' => $v,
					'p' => $path,
				);
			}
			// get variant
			if ( stripos( $k, 'font' ) !== false && stripos( $k, 'variant' ) !== false && ! empty( $v ) && strpos( $v, ',' ) === false ) {
				$load_variants[] = array(
					'k' => $k,
					'v' => $v,
					'p' => $path,
				);
			}
		}
	}
	return array_merge( $load_fonts, $load_variants );
}

function seedprod_lite_construct_font_str( $doc_settings ) {
	$fonts      = seedprod_lite_find_fonts_in_doc( $doc_settings );
	$myfonts    = array();
	$myvariants = array();
	if ( ! empty( $fonts ) ) {
		foreach ( $fonts as $k => $v ) {
			if ( stripos( $v['k'], 'font' ) !== false && stripos( $v['k'], 'variant' ) === false ) {
				if ( empty( $myfonts[ $v['v'] ] ) ) {
					$myfonts[ $v['v'] ] = array();
				}

				foreach ( $fonts as $k2 => $v2 ) {
					if ( $v['p'] . 'Variant' === $v2['p'] ) {
						$myfonts[ $v['v'] ][] = $v2['v'];
					}
				}
			}
		}

		foreach ( $myfonts as $k3 => $v3 ) {
			$myfonts[ $k3 ] = array_unique( $v3 );
		}
	}
	$google_fonts_str = '';
	if ( ! empty( $myfonts ) ) {
		$google_fonts_str = 'https://fonts.googleapis.com/css?family=';
		$c                = 1;
		foreach ( $myfonts as $k4 => $v4 ) {
			$end = '|';
			if ( count( $myfonts ) == $c ) {
				$end = '';
			}
			$google_fonts_str .= urlencode( $k4 );
			if ( ! empty( $v4 ) ) {
				$google_fonts_str .= ':' . implode( ',', $v4 );
			}

			$google_fonts_str .= $end;
			$c++;
		}
		$google_fonts_str .= '&display=swap';
	}
	return $google_fonts_str;
}


add_filter( '_wp_post_revision_fields', 'seedprod_lite_wp_post_revision_fields', 11, 2 );
function seedprod_lite_wp_post_revision_fields( $fields, $post ) {
	if ( ! empty( $post['post_content_filtered'] ) && strpos( $post['post_content'], 'sp-page' ) !== false ) {
		 $fields['post_content_filtered'] = 'Content Filtered';
		 return $fields;
	} else {
		return $fields;
	}
}


add_filter( 'page_row_actions', 'seedprod_lite_filter_page_row_actions', 11, 2 );
function seedprod_lite_filter_page_row_actions( $actions, $post ) {
	$has_settings = get_post_meta( $post->ID, '_seedprod_page', true );
	if ( ! empty( $has_settings ) ) {
		$id                       = $post->ID;
		$actions['edit_seedprod'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			admin_url() . 'admin.php?page=seedprod_lite_builder&id=' . $id . '#/setup/' . $id,
			__( 'Edit with SeedProd', 'seedprod' )
		);
		// unset($actions['inline hide-if-no-js']);
	}

	return $actions;
}

//add_filter( 'get_edit_post_link', 'seedprod_lite_filter_get_edit_post_link', 11, 3 );
function seedprod_lite_filter_get_edit_post_link( $link, $id, $context ) {
	$has_settings = get_post_meta( $id, '_seedprod_page', true );
	if ( ! empty( $has_settings ) ) {
		$link = admin_url() . 'admin.php?page=seedprod_lite_builder&id=' . $id . '#/setup/' . $id;
	}
	return $link;
}

/**
 * Dismiss Settings Lite CTA
 */
function seedprod_lite_dismiss_settings_lite_cta() {
	if ( check_ajax_referer( 'seedprod_lite_dismiss_settings_lite_cta' ) ) {

		if ( ! empty( $_POST['dismiss'] ) ) {
			update_option( 'seedprod_dismiss_settings_lite_cta', true );

			$response = array(
				'status' => 'true',

			);
		}

		// Send Response
		wp_send_json( $response );
		exit;
	}
}

/**
 * Dismiss Lite Banners
 */
function seedprod_lite_dismiss_upsell() {
	if ( check_ajax_referer( 'seedprod_lite_dismiss_upsell' ) ) {

		if ( ! empty( $_POST['id'] ) ) {
			$ts = time();
			update_option( 'seedprod_dismiss_upsell_' . absint($_POST['id']), $ts );
			$response = array(
				'status' => 'true',

			);
		}

		// Send Response
		wp_send_json( $response );
		exit;
	}
}

function seedprod_lite_get_expire_times() {
	return array(
		'1'    => '1 Hour',
		'2'    => '2 Hours',
		'3'    => '3 Hours',
		'4'    => '4 Hours',
		'5'    => '5 Hours',
		'6'    => '6 Hours',
		'7'    => '7 Hours',
		'8'    => '8 Hours',
		'9'    => '9 Hours',
		'10'   => '10 Hours',
		'11'   => '11 Hours',
		'12'   => '12 Hours',
		'13'   => '13 Hours',
		'14'   => '14 Hours',
		'15'   => '15 Hours',
		'16'   => '16 Hours',
		'17'   => '17 Hours',
		'18'   => '18 Hours',
		'19'   => '19 Hours',
		'20'   => '20 Hours',
		'21'   => '21 Hours',
		'21'   => '22 Hours',
		'23'   => '23 Hours',
		'24'   => '1 Day',
		'48'   => '2 Days',
		'72'   => '3 Days',
		'96'   => '4 Days',
		'120'  => '5 Days',
		'144'  => '6 Days',
		'168'  => '7 Days',
		'192'  => '8 Days',
		'216'  => '9 Days',
		'240'  => '10 Days',
		'264'  => '11 Days',
		'288'  => '12 Days',
		'312'  => '13 Days',
		'336'  => '14 Days',
		'360'  => '15 Days',
		'384'  => '16 Days',
		'408'  => '17 Days',
		'432'  => '18 Days',
		'456'  => '19 Days',
		'480'  => '20 Days',
		'504'  => '21 Days',
		'528'  => '22 Days',
		'552'  => '23 Days',
		'576'  => '24 Days',
		'600'  => '25 Days',
		'624'  => '26 Days',
		'648'  => '27 Days',
		'672'  => '28 Days',
		'696'  => '29 Days',
		'720'  => '30 Days',
		'8760' => '1 Year',
	);
}



function seedprod_lite_get_system_info() {

	global $wpdb;

	// Get theme info.
	$theme_data = wp_get_theme();
	$theme      = $theme_data->Name . ' ' . $theme_data->Version;

	$return = '### Begin System Info ###' . "\n\n";

	// WPForms info.
	$return .= '-- SeedProd Info' . "\n\n";

	// Now the basics...
	$return .= "\n" . '-- Site Info' . "\n\n";
	$return .= 'Site URL:                 ' . site_url() . "\n";
	$return .= 'Home URL:                 ' . home_url() . "\n";
	$return .= 'Multisite:                ' . ( is_multisite() ? 'Yes' : 'No' ) . "\n";

	// WordPress configuration.
	$return .= "\n" . '-- WordPress Configuration' . "\n\n";
	$return .= 'Version:                  ' . get_bloginfo( 'version' ) . "\n";
	$return .= 'Language:                 ' . ( defined( 'WPLANG' ) && WPLANG ? WPLANG : 'en_US' ) . "\n";
	$return .= 'Permalink Structure:      ' . ( get_option( 'permalink_structure' ) ? get_option( 'permalink_structure' ) : 'Default' ) . "\n";
	$return .= 'Active Theme:             ' . $theme . "\n";
	$return .= 'Show On Front:            ' . get_option( 'show_on_front' ) . "\n";
	// Only show page specs if front page is set to 'page'.
	if ( get_option( 'show_on_front' ) === 'page' ) {
		$front_page_id = get_option( 'page_on_front' );
		$blog_page_id  = get_option( 'page_for_posts' );

		$return .= 'Page On Front:            ' . ( 0 != $front_page_id ? get_the_title( $front_page_id ) . ' (#' . $front_page_id . ')' : 'Unset' ) . "\n";
		$return .= 'Page For Posts:           ' . ( 0 != $blog_page_id ? get_the_title( $blog_page_id ) . ' (#' . $blog_page_id . ')' : 'Unset' ) . "\n";
	}
	$return .= 'ABSPATH:                  ' . ABSPATH . "\n";
	$return .= 'Table Prefix:             ' . 'Length: ' . strlen( $wpdb->prefix ) . '   Status: ' . ( strlen( $wpdb->prefix ) > 16 ? 'ERROR: Too long' : 'Acceptable' ) . "\n";
	$return .= 'WP_DEBUG:                 ' . ( defined( 'WP_DEBUG' ) ? WP_DEBUG ? 'Enabled' : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'Memory Limit:             ' . WP_MEMORY_LIMIT . "\n";
	$return .= 'Registered Post Stati:    ' . implode( ', ', get_post_stati() ) . "\n";

	// @todo WPForms configuration/specific details.
	$return .= "\n" . '-- WordPress Uploads/Constants' . "\n\n";
	$return .= 'WP_CONTENT_DIR:           ' . ( defined( 'WP_CONTENT_DIR' ) ? WP_CONTENT_DIR ? WP_CONTENT_DIR : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'WP_CONTENT_URL:           ' . ( defined( 'WP_CONTENT_URL' ) ? WP_CONTENT_URL ? WP_CONTENT_URL : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'UPLOADS:                  ' . ( defined( 'UPLOADS' ) ? UPLOADS ? UPLOADS : 'Disabled' : 'Not set' ) . "\n";

	$uploads_dir = wp_upload_dir();

	$return .= 'wp_uploads_dir() path:    ' . $uploads_dir['path'] . "\n";
	$return .= 'wp_uploads_dir() url:     ' . $uploads_dir['url'] . "\n";
	$return .= 'wp_uploads_dir() basedir: ' . $uploads_dir['basedir'] . "\n";
	$return .= 'wp_uploads_dir() baseurl: ' . $uploads_dir['baseurl'] . "\n";

	// Get plugins that have an update.
	$updates = get_plugin_updates();

	// Must-use plugins.
	// NOTE: MU plugins can't show updates!
	$muplugins = get_mu_plugins();
	if ( count( $muplugins ) > 0 && ! empty( $muplugins ) ) {
		$return .= "\n" . '-- Must-Use Plugins' . "\n\n";

		foreach ( $muplugins as $plugin => $plugin_data ) {
			$return .= $plugin_data['Name'] . ': ' . $plugin_data['Version'] . "\n";
		}
	}

	// WordPress active plugins.
	$return .= "\n" . '-- WordPress Active Plugins' . "\n\n";

	$plugins        = get_plugins();
	$active_plugins = get_option( 'active_plugins', array() );

	foreach ( $plugins as $plugin_path => $plugin ) {
		if ( ! in_array( $plugin_path, $active_plugins, true ) ) {
			continue;
		}
		$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	// WordPress inactive plugins.
	$return .= "\n" . '-- WordPress Inactive Plugins' . "\n\n";

	foreach ( $plugins as $plugin_path => $plugin ) {
		if ( in_array( $plugin_path, $active_plugins, true ) ) {
			continue;
		}
		$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	if ( is_multisite() ) {
		// WordPress Multisite active plugins.
		$return .= "\n" . '-- Network Active Plugins' . "\n\n";

		$plugins        = wp_get_active_network_plugins();
		$active_plugins = get_site_option( 'active_sitewide_plugins', array() );

		foreach ( $plugins as $plugin_path ) {
			$plugin_base = plugin_basename( $plugin_path );
			if ( ! array_key_exists( $plugin_base, $active_plugins ) ) {
				continue;
			}
			$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
			$plugin  = get_plugin_data( $plugin_path );
			$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
		}
	}

	// Server configuration (really just versions).
	$return .= "\n" . '-- Webserver Configuration' . "\n\n";
	$return .= 'PHP Version:              ' . PHP_VERSION . "\n";
	$return .= 'MySQL Version:            ' . $wpdb->db_version() . "\n";
	$return .= 'Webserver Info:           ' . $_SERVER['SERVER_SOFTWARE'] . "\n";

	// PHP configs... now we're getting to the important stuff.
	$return .= "\n" . '-- PHP Configuration' . "\n\n";
	$return .= 'Memory Limit:             ' . ini_get( 'memory_limit' ) . "\n";
	$return .= 'Upload Max Size:          ' . ini_get( 'upload_max_filesize' ) . "\n";
	$return .= 'Post Max Size:            ' . ini_get( 'post_max_size' ) . "\n";
	$return .= 'Upload Max Filesize:      ' . ini_get( 'upload_max_filesize' ) . "\n";
	$return .= 'Time Limit:               ' . ini_get( 'max_execution_time' ) . "\n";
	$return .= 'Max Input Vars:           ' . ini_get( 'max_input_vars' ) . "\n";
	$return .= 'Display Errors:           ' . ( ini_get( 'display_errors' ) ? 'On (' . ini_get( 'display_errors' ) . ')' : 'N/A' ) . "\n";

	// PHP extensions and such.
	$return .= "\n" . '-- PHP Extensions' . "\n\n";
	$return .= 'cURL:                     ' . ( function_exists( 'curl_init' ) ? 'Supported' : 'Not Supported' ) . "\n";
	$return .= 'fsockopen:                ' . ( function_exists( 'fsockopen' ) ? 'Supported' : 'Not Supported' ) . "\n";
	$return .= 'SOAP Client:              ' . ( class_exists( 'SoapClient', false ) ? 'Installed' : 'Not Installed' ) . "\n";
	$return .= 'Suhosin:                  ' . ( extension_loaded( 'suhosin' ) ? 'Installed' : 'Not Installed' ) . "\n";

	// Session stuff.
	$return .= "\n" . '-- Session Configuration' . "\n\n";
	$return .= 'Session:                  ' . ( isset( $_SESSION ) ? 'Enabled' : 'Disabled' ) . "\n";

	// The rest of this is only relevant if session is enabled.
	if ( isset( $_SESSION ) ) {
		$return .= 'Session Name:             ' . esc_html( ini_get( 'session.name' ) ) . "\n";
		$return .= 'Cookie Path:              ' . esc_html( ini_get( 'session.cookie_path' ) ) . "\n";
		$return .= 'Save Path:                ' . esc_html( ini_get( 'session.save_path' ) ) . "\n";
		$return .= 'Use Cookies:              ' . ( ini_get( 'session.use_cookies' ) ? 'On' : 'Off' ) . "\n";
		$return .= 'Use Only Cookies:         ' . ( ini_get( 'session.use_only_cookies' ) ? 'On' : 'Off' ) . "\n";
	}

	$return .= "\n" . '### End System Info ###';

	return $return;
}

/**
 * If site uses WP Rocket, disable minify for CSS & JS
 */
function seedprod_lite_wprocket_disable_minify() {
	if ( function_exists( 'rocket_define_donotminify_constants' ) ) {
		rocket_define_donotminify_constants( 'true' );
	}
}





