<?php
/**
 * Class Country_Flags
 *
 * @package WooCommerce\Payments
 */

namespace WCPay\Multi_Currency;

defined( 'ABSPATH' ) || exit;

/**
 * Class that bring flags per country/currency.
 */
class Country_Flags {

	const EMOJI_COUNTRIES_FLAGS = [
		'AD' => '🇦🇩',
		'AE' => '🇦🇪',
		'AF' => '🇦🇫',
		'AG' => '🇦🇬',
		'AI' => '🇦🇮',
		'AL' => '🇦🇱',
		'AM' => '🇦🇲',
		'AO' => '🇦🇴',
		'AQ' => '🇦🇶',
		'AR' => '🇦🇷',
		'AS' => '🇦🇸',
		'AT' => '🇦🇹',
		'AU' => '🇦🇺',
		'AW' => '🇦🇼',
		'AX' => '🇦🇽',
		'AZ' => '🇦🇿',
		'BA' => '🇧🇦',
		'BB' => '🇧🇧',
		'BD' => '🇧🇩',
		'BE' => '🇧🇪',
		'BF' => '🇧🇫',
		'BG' => '🇧🇬',
		'BH' => '🇧🇭',
		'BI' => '🇧🇮',
		'BJ' => '🇧🇯',
		'BL' => '🇧🇱',
		'BM' => '🇧🇲',
		'BN' => '🇧🇳',
		'BO' => '🇧🇴',
		'BQ' => '🇧🇶',
		'BR' => '🇧🇷',
		'BS' => '🇧🇸',
		'BT' => '🇧🇹',
		'BV' => '🇧🇻',
		'BW' => '🇧🇼',
		'BY' => '🇧🇾',
		'BZ' => '🇧🇿',
		'CA' => '🇨🇦',
		'CC' => '🇨🇨',
		'CD' => '🇨🇩',
		'CF' => '🇨🇫',
		'CG' => '🇨🇬',
		'CH' => '🇨🇭',
		'CI' => '🇨🇮',
		'CK' => '🇨🇰',
		'CL' => '🇨🇱',
		'CM' => '🇨🇲',
		'CN' => '🇨🇳',
		'CO' => '🇨🇴',
		'CR' => '🇨🇷',
		'CU' => '🇨🇺',
		'CV' => '🇨🇻',
		'CW' => '🇨🇼',
		'CX' => '🇨🇽',
		'CY' => '🇨🇾',
		'CZ' => '🇨🇿',
		'DE' => '🇩🇪',
		'DJ' => '🇩🇯',
		'DK' => '🇩🇰',
		'DM' => '🇩🇲',
		'DO' => '🇩🇴',
		'DZ' => '🇩🇿',
		'EC' => '🇪🇨',
		'EE' => '🇪🇪',
		'EG' => '🇪🇬',
		'EH' => '🇪🇭',
		'ER' => '🇪🇷',
		'ES' => '🇪🇸',
		'ET' => '🇪🇹',
		'EU' => '🇪🇺',
		'FI' => '🇫🇮',
		'FJ' => '🇫🇯',
		'FK' => '🇫🇰',
		'FM' => '🇫🇲',
		'FO' => '🇫🇴',
		'FR' => '🇫🇷',
		'GA' => '🇬🇦',
		'GB' => '🇬🇧',
		'GD' => '🇬🇩',
		'GE' => '🇬🇪',
		'GF' => '🇬🇫',
		'GG' => '🇬🇬',
		'GH' => '🇬🇭',
		'GI' => '🇬🇮',
		'GL' => '🇬🇱',
		'GM' => '🇬🇲',
		'GN' => '🇬🇳',
		'GP' => '🇬🇵',
		'GQ' => '🇬🇶',
		'GR' => '🇬🇷',
		'GS' => '🇬🇸',
		'GT' => '🇬🇹',
		'GU' => '🇬🇺',
		'GW' => '🇬🇼',
		'GY' => '🇬🇾',
		'HK' => '🇭🇰',
		'HM' => '🇭🇲',
		'HN' => '🇭🇳',
		'HR' => '🇭🇷',
		'HT' => '🇭🇹',
		'HU' => '🇭🇺',
		'ID' => '🇮🇩',
		'IE' => '🇮🇪',
		'IL' => '🇮🇱',
		'IM' => '🇮🇲',
		'IN' => '🇮🇳',
		'IO' => '🇮🇴',
		'IQ' => '🇮🇶',
		'IR' => '🇮🇷',
		'IS' => '🇮🇸',
		'IT' => '🇮🇹',
		'JE' => '🇯🇪',
		'JM' => '🇯🇲',
		'JO' => '🇯🇴',
		'JP' => '🇯🇵',
		'KE' => '🇰🇪',
		'KG' => '🇰🇬',
		'KH' => '🇰🇭',
		'KI' => '🇰🇮',
		'KM' => '🇰🇲',
		'KN' => '🇰🇳',
		'KP' => '🇰🇵',
		'KR' => '🇰🇷',
		'KW' => '🇰🇼',
		'KY' => '🇰🇾',
		'KZ' => '🇰🇿',
		'LA' => '🇱🇦',
		'LB' => '🇱🇧',
		'LC' => '🇱🇨',
		'LI' => '🇱🇮',
		'LK' => '🇱🇰',
		'LR' => '🇱🇷',
		'LS' => '🇱🇸',
		'LT' => '🇱🇹',
		'LU' => '🇱🇺',
		'LV' => '🇱🇻',
		'LY' => '🇱🇾',
		'MA' => '🇲🇦',
		'MC' => '🇲🇨',
		'MD' => '🇲🇩',
		'ME' => '🇲🇪',
		'MF' => '🇲🇫',
		'MG' => '🇲🇬',
		'MH' => '🇲🇭',
		'MK' => '🇲🇰',
		'ML' => '🇲🇱',
		'MM' => '🇲🇲',
		'MN' => '🇲🇳',
		'MO' => '🇲🇴',
		'MP' => '🇲🇵',
		'MQ' => '🇲🇶',
		'MR' => '🇲🇷',
		'MS' => '🇲🇸',
		'MT' => '🇲🇹',
		'MU' => '🇲🇺',
		'MV' => '🇲🇻',
		'MW' => '🇲🇼',
		'MX' => '🇲🇽',
		'MY' => '🇲🇾',
		'MZ' => '🇲🇿',
		'NA' => '🇳🇦',
		'NC' => '🇳🇨',
		'NE' => '🇳🇪',
		'NF' => '🇳🇫',
		'NG' => '🇳🇬',
		'NI' => '🇳🇮',
		'NL' => '🇳🇱',
		'NO' => '🇳🇴',
		'NP' => '🇳🇵',
		'NR' => '🇳🇷',
		'NU' => '🇳🇺',
		'NZ' => '🇳🇿',
		'OM' => '🇴🇲',
		'PA' => '🇵🇦',
		'PE' => '🇵🇪',
		'PF' => '🇵🇫',
		'PG' => '🇵🇬',
		'PH' => '🇵🇭',
		'PK' => '🇵🇰',
		'PL' => '🇵🇱',
		'PM' => '🇵🇲',
		'PN' => '🇵🇳',
		'PR' => '🇵🇷',
		'PS' => '🇵🇸',
		'PT' => '🇵🇹',
		'PW' => '🇵🇼',
		'PY' => '🇵🇾',
		'QA' => '🇶🇦',
		'RE' => '🇷🇪',
		'RO' => '🇷🇴',
		'RS' => '🇷🇸',
		'RU' => '🇷🇺',
		'RW' => '🇷🇼',
		'SA' => '🇸🇦',
		'SB' => '🇸🇧',
		'SC' => '🇸🇨',
		'SD' => '🇸🇩',
		'SE' => '🇸🇪',
		'SG' => '🇸🇬',
		'SH' => '🇸🇭',
		'SI' => '🇸🇮',
		'SJ' => '🇸🇯',
		'SK' => '🇸🇰',
		'SL' => '🇸🇱',
		'SM' => '🇸🇲',
		'SN' => '🇸🇳',
		'SO' => '🇸🇴',
		'SR' => '🇸🇷',
		'SS' => '🇸🇸',
		'ST' => '🇸🇹',
		'SV' => '🇸🇻',
		'SX' => '🇸🇽',
		'SY' => '🇸🇾',
		'SZ' => '🇸🇿',
		'TC' => '🇹🇨',
		'TD' => '🇹🇩',
		'TF' => '🇹🇫',
		'TG' => '🇹🇬',
		'TH' => '🇹🇭',
		'TJ' => '🇹🇯',
		'TK' => '🇹🇰',
		'TL' => '🇹🇱',
		'TM' => '🇹🇲',
		'TN' => '🇹🇳',
		'TO' => '🇹🇴',
		'TR' => '🇹🇷',
		'TT' => '🇹🇹',
		'TV' => '🇹🇻',
		'TW' => '🇹🇼',
		'TZ' => '🇹🇿',
		'UA' => '🇺🇦',
		'UG' => '🇺🇬',
		'UM' => '🇺🇲',
		'US' => '🇺🇸',
		'UY' => '🇺🇾',
		'UZ' => '🇺🇿',
		'VA' => '🇻🇦',
		'VC' => '🇻🇨',
		'VE' => '🇻🇪',
		'VG' => '🇻🇬',
		'VI' => '🇻🇮',
		'VN' => '🇻🇳',
		'VU' => '🇻🇺',
		'WF' => '🇼🇫',
		'WS' => '🇼🇸',
		'XK' => '🇽🇰',
		'YE' => '🇾🇪',
		'YT' => '🇾🇹',
		'ZA' => '🇿🇦',
		'ZM' => '🇿🇲',
		'ZW' => '🇿🇼',
	];

	/**
	 * Retrieves a flag by country code.
	 *
	 * @param string $country country alpha-2 code (ISO 3166) like US.
	 * @return string
	 */
	public static function get_by_country( string $country ): string {
		return self::EMOJI_COUNTRIES_FLAGS[ $country ] ?? '';
	}

	/**
	 * Retrieves a flag by currency code.
	 *
	 * @param string $currency currency code (ISO 4217) like USD.
	 * @return string
	 */
	public static function get_by_currency( string $currency ): string {
		return self::get_by_country( substr( $currency, 0, -1 ) );
	}
}
