<?php
/**
 * Popup template
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Return if logged in
if ( is_user_logged_in() ) {
	return;
}

// Classes
$classes = array( 'wpl-popup-block' );

// Background image
if ( '' != get_theme_mod( 'wpl_popup_login_style_bg' ) ) {
	$classes[] = 'has-background-image';
}

// Turn classes into space seperated string
$classes = implode( ' ', $classes );

// If registration is enabled
$can_register = get_option( 'users_can_register' ); 

// Vars
$login_title   			= woovina_tm_translation( 'wpl_popup_login_text_title', get_theme_mod( 'wpl_popup_login_text_title' ) );
$login_title 			= $login_title ? $login_title : esc_html__( 'Log in', 'woovina-popup-login' );
$login_content 			= woovina_tm_translation( 'wpl_popup_login_text_content', get_theme_mod( 'wpl_popup_login_text_content' ) );
$login_content 			= $login_content ? $login_content : esc_html__( 'Become a part of our community!', 'woovina-popup-login' );
$register_title   		= woovina_tm_translation( 'wpl_popup_register_text_title', get_theme_mod( 'wpl_popup_register_text_title' ) );
$register_title 		= $register_title ? $register_title : esc_html__( 'Create an account', 'woovina-popup-login' );
$register_content 		= woovina_tm_translation( 'wpl_popup_register_text_content', get_theme_mod( 'wpl_popup_register_text_content' ) );
$register_content 		= $register_content ? $register_content : esc_html__( 'Welcome! Register for an account', 'woovina-popup-login' );
$lost_password_title   	= woovina_tm_translation( 'wpl_popup_lost_password_text_title', get_theme_mod( 'wpl_popup_lost_password_text_title' ) );
$lost_password_title 	= $lost_password_title ? $lost_password_title : esc_html__( 'Reset password', 'woovina-popup-login' );
$lost_password_content 	= woovina_tm_translation( 'wpl_popup_lost_password_text_content', get_theme_mod( 'wpl_popup_lost_password_text_content' ) );
$lost_password_content 	= $lost_password_content ? $lost_password_content : esc_html__( 'Recover your password', 'woovina-popup-login' );

// Redirections
$login_redirect 		= get_theme_mod( 'wpl_popup_login_redirect' );
$register_redirect 		= get_theme_mod( 'wpl_popup_register_redirect' ); ?>

<div id="wpl-login-form">

	<div class="wpl-login-container">

		<div class="wpl-login-content">

			<div class="<?php echo esc_attr( $classes ); ?>">

				<div class="wpl-login-wrap">

					<div class="wpl-login wpl-wrap wpl-show">

						<?php do_action( 'wpl_before_login' ); ?>
						
						<header class="content-header">
							<h3 class="wpl-title"><?php esc_html_e( $login_title ); ?></h3>
							<div class="wpl-intro"><?php esc_html_e( $login_content ); ?></div>
						</header>

						<div class="wpl-errors"></div>

						<?php do_action( 'wpl_after_login_form' ); ?>

						<form id="wpl_login_form" action="<?php echo home_url( '/' ); ?>" method="post">

							<?php do_action( 'wpl_before_login_form_inner' ); ?>

							<div class="form-field input-wrap">
								<input type="text" class="form-control input-lg required" name="wpl_user_login" id="wpl_user_login" value="" required />
								<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Username', 'woovina-popup-login' ); ?></label>
								<div class="wpl-line"></div>
								<div class="wpl-focus-line"></div>
							</div>

							<div class="form-field input-wrap">
								<input type="password" class="form-control input-lg required" name="wpl_user_pass" id="wpl_user_pass" value="" required />
								<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Password', 'woovina-popup-login' ); ?></label>
								<div class="wpl-line"></div>
								<div class="wpl-focus-line"></div>
							</div>

							<div class="form-field input-wrap wpl-remember">
								<label><input name="wpl_user_remember" type="checkbox" id="wpl_user_remember" value="forever" /> <?php esc_html_e( 'Remember Me', 'woovina-popup-login' ); ?></label>
							</div>

							<div class="form-field">
								<input type="hidden" name="action" value="wpl_login_member"/>
								<?php
								if ( ! empty( $login_redirect ) ) { ?>
									<input type="hidden" name="redirect_to" value="<?php echo esc_attr( $login_redirect ); ?>">
								<?php
								} ?>
								<button type="submit" name="login_button" id="login_button" class="wpl-button" data-loading-text="<?php esc_html_e( 'Loading...', 'woovina-popup-login' ); ?>"><?php esc_html_e( 'Login', 'woovina-popup-login' ); ?></button>
							</div>

							<?php wp_nonce_field( 'wpl-login-nonce', 'login-security' ); ?>

							<div class="wpl-text"><a href="#" class="forgot-pass-link"><?php esc_html_e( 'Forgot your password? Get help', 'woovina-popup-login' ); ?></a></div>

							<?php do_action( 'wpl_after_login_form_inner' ); ?>

						</form>

						<?php do_action( 'wpl_after_login_form' ); ?>

						<?php
						if ( function_exists( 'the_privacy_policy_link' ) ) {
							the_privacy_policy_link( '<div class="wpl-privacy">', '</div>' );
						} ?>

						<?php
						// If WordPress Social Login is enabled
						if ( function_exists( 'wsl_load_plugin_textdomain' ) ) { ?>
							<div class="wpl-social-login-wrap">
								<div class="wpl-social-title"><span><?php esc_html_e( 'Or log in with', 'woovina-popup-login' ); ?></span></div>
								<?php do_action( 'wpl_wp_social_login' ); ?>
							</div>
						<?php
						}

						// If Nextend Social Login is enabled
						if ( class_exists( 'NextendSocialLogin', false ) ) { ?>
							<div class="wpl-social-login-wrap">
								<div class="wpl-social-title"><span><?php esc_html_e( 'Or log in with', 'woovina-popup-login' ); ?></span></div>
								<?php echo NextendSocialLogin::renderButtonsWithContainer(); ?>
							</div>
						<?php
						} ?>

						<?php
						// If registraion is enabled
						if ( $can_register ) { ?>

							<div class="wpl-bottom">
								<div class="text"><?php esc_html_e( 'Not a member?', 'woovina-popup-login' ); ?></div>
								<a href="#" class="register-link wpl-btn"><?php esc_html_e( 'Sign up', 'woovina-popup-login' ); ?></a>
							</div>

						<?php
						} ?>

						<?php do_action( 'wpl_after_login' ); ?>

					</div>

					<?php
					// If registraion is enabled
					if ( $can_register ) { ?>

						<div class="wpl-register wpl-wrap wpl-hide">

							<?php do_action( 'wpl_before_register' ); ?>
						
							<header class="content-header">
								<h3 class="wpl-title"><?php esc_html_e( $register_title ); ?></h3>
								<div class="wpl-intro"><?php esc_html_e( $register_content ); ?></div>
							</header>

							<div class="wpl-errors"></div>

							<?php do_action( 'wpl_before_register_form' ); ?>

							<form id="wpl_registration_form" action="<?php echo home_url( '/' ); ?>" method="post">

								<?php do_action( 'wpl_before_register_form_inner' ); ?>

								<div class="form-field input-wrap">
									<input type="text" class="form-control input-lg required" name="wpl_register_login" id="wpl_register_login" value="" required />
									<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Your username', 'woovina-popup-login' ); ?></label>
									<div class="wpl-line"></div>
									<div class="wpl-focus-line"></div>
								</div>

								<div class="form-field input-wrap">
									<input type="email" class="form-control input-lg required" name="wpl_register_email" id="wpl_register_email" value="" required />
									<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Your email', 'woovina-popup-login' ); ?></label>
									<div class="wpl-line"></div>
									<div class="wpl-focus-line"></div>
								</div>

								<div class="form-field input-wrap">
									<input type="password" class="form-control input-lg required" name="wpl_register_pass" id="wpl_register_pass" value="" required />
									<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Password', 'woovina-popup-login' ); ?></label>
									<div class="wpl-line"></div>
									<div class="wpl-focus-line"></div>
								</div>

								<div class="form-field input-wrap">
									<input type="password" class="form-control input-lg required" name="wpl_register_pass2" id="wpl_register_pass2" value="" required />
									<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Confirm Password', 'woovina-popup-login' ); ?></label>
									<div class="wpl-line"></div>
									<div class="wpl-focus-line"></div>
								</div>

								<input type="hidden" name="action" value="wpl_register_member"/>
								<?php
								if ( ! empty( $register_redirect ) ) { ?>
									<input type="hidden" name="redirect_to" value="<?php echo esc_attr( $register_redirect ); ?>">
								<?php
								} ?>
								<button type="submit" name="register_button" id="register_button" class="wpl-button" data-loading-text="<?php esc_html_e( 'Loading...', 'woovina-popup-login' ); ?>"><?php esc_html_e( 'Register', 'woovina-popup-login' ); ?></button>

								<?php wp_nonce_field( 'wpl-login-nonce', 'register-security' ); ?>

								<?php do_action( 'wpl_after_register_form_inner' ); ?>

							</form>

							<?php do_action( 'wpl_after_register_form' ); ?>

							<?php
							// If WordPress Social Login is enabled
							if ( function_exists( 'wsl_load_plugin_textdomain' ) ) { ?>
								<div class="wpl-social-login-wrap">
									<div class="wpl-social-title"><span><?php esc_html_e( 'Or register with', 'woovina-popup-login' ); ?></span></div>
									<?php do_action( 'wpl_wp_social_register' ); ?>
								</div>
							<?php
							}

							// If Nextend Social Login is enabled
							if ( class_exists( 'NextendSocialLogin', false ) ) { ?>
								<div class="wpl-social-login-wrap">
									<div class="wpl-social-title"><span><?php esc_html_e( 'Or register with', 'woovina-popup-login' ); ?></span></div>
									<?php echo NextendSocialLogin::renderButtonsWithContainer(); ?>
								</div>
							<?php
							} ?>

							<?php
							if ( function_exists( 'the_privacy_policy_link' ) ) {
								the_privacy_policy_link( '<div class="wpl-privacy">', '</div>');
							} ?>

							<div class="wpl-bottom">
								<div class="text"><?php esc_html_e( 'Already a member?', 'woovina-popup-login' ); ?></div>
								<a href="#" class="login-link wpl-btn"><?php esc_html_e( 'Sign in', 'woovina-popup-login' ); ?></a>
							</div>

							<?php do_action( 'wpl_after_register' ); ?>

						</div>

					<?php
					} ?>

					<div class="wpl-reset-password wpl-wrap wpl-hide">

						<?php do_action( 'wpl_before_reset_password' ); ?>
						
						<header class="content-header">
							<h3 class="wpl-title"><?php esc_html_e( $lost_password_title ); ?></h3>
							<div class="wpl-intro"><?php esc_html_e( $lost_password_content ); ?></div>
						</header>
						
						<div class="wpl-errors"></div>

						<?php do_action( 'wpl_before_reset_password_form' ); ?>

						<form id="wpl_reset_password_form" action="<?php echo home_url( '/' ); ?>" method="post">

							<?php do_action( 'wpl_before_reset_password_form_inner' ); ?>

							<div class="form-field input-wrap">
								<input type="text" class="form-control input-lg required" name="wpl_user_or_email" id="wpl_user_or_email" value="" required />
								<label class="wpl-label" aria-hidden="true"><?php esc_html_e( 'Username or E-mail', 'woovina-popup-login' ); ?></label>
								<div class="wpl-line"></div>
								<div class="wpl-focus-line"></div>
							</div>

							<div class="form-field">
								<input type="hidden" name="action" value="wpl_reset_password" />
								<button type="submit" name="forgot_button" id="forgot_button" class="wpl-button" data-loading-text="<?php esc_html_e( 'Loading...', 'woovina-popup-login' ); ?>"><?php esc_html_e( 'Send My Password', 'woovina-popup-login' ); ?></button>
							</div>

							<?php wp_nonce_field( 'wpl-login-nonce', 'password-security' ); ?>

							<div class="wpl-text"><?php esc_html_e( 'A password will be e-mailed to you.', 'woovina-popup-login' ); ?></div>

							<?php do_action( 'wpl_after_reset_password_form_inner' ); ?>

						</form>

						<?php do_action( 'wpl_after_reset_password_form' ); ?>

						<?php
						if ( function_exists( 'the_privacy_policy_link' ) ) {
							the_privacy_policy_link( '<div class="wpl-privacy">', '</div>');
						} ?>

						<div class="wpl-bottom">
							<div class="text"><?php esc_html_e( 'Back to', 'woovina-popup-login' ); ?></div>
							<a href="#" class="login-link wpl-btn"><?php esc_html_e( 'Login', 'woovina-popup-login' ); ?></a>
						</div>

						<?php do_action( 'wpl_after_reset_password' ); ?>

					</div>

				</div>

				<a href="#" class="wpl-close-button">×</a>

			</div>

		</div>

	</div>

	<div class="wpl-overlay"></div>

</div>