<?php
/**
 * Plugin Name:			WooVina Product Sharing
 * Plugin URI:			https://woovina.com/extensions/woovina-product-sharing/
 * Description:			A simple plugin to add social share buttons to your product page.
 * Version:				1.1.1
 * Author:				WooVina
 * Author URI:			https://woovina.com/
 * Requires at least:	4.5.0
 * Tested up to:		5.2.3
 *
 * Text Domain: woovina-product-sharing
 * Domain Path: /languages/
 *
 * @package WooVina_Product_Sharing
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Returns the main instance of WooVina_Product_Sharing to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return object WooVina_Product_Sharing
 */
function WooVina_Product_Sharing() {
	return WooVina_Product_Sharing::instance();
} // End WooVina_Product_Sharing()

WooVina_Product_Sharing();

/**
 * Main WooVina_Product_Sharing Class
 *
 * @class WooVina_Product_Sharing
 * @version	1.0.0
 * @since 1.0.0
 * @package	WooVina_Product_Sharing
 */
final class WooVina_Product_Sharing {
	/**
	 * WooVina_Product_Sharing The single instance of WooVina_Product_Sharing.
	 * @var 	object
	 * @access  private
	 * @since 	1.0.0
	 */
	private static $_instance = null;

	/**
	 * The token.
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $token;

	/**
	 * The version number.
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $version;

	// Admin - Start
	/**
	 * The admin object.
	 * @var     object
	 * @access  public
	 * @since   1.0.0
	 */
	public $admin;
	
	/**
	 * Constructor function.
	 * @access  public
	 * @since   1.0.0
	 * @return  void
	 */
	public function __construct( $widget_areas = array() ) {
		$this->token 			= 'woovina-product-sharing';
		$this->plugin_url 		= plugin_dir_url( __FILE__ );
		$this->plugin_path 		= plugin_dir_path( __FILE__ );
		$this->version 			= '1.1.1';
		
		register_activation_hook( __FILE__, array( $this, 'install' ) );
				
		add_action( 'init', array( $this, 'wps_load_plugin_textdomain' ) );

		add_action( 'init', array( $this, 'wps_setup' ) );
		
		add_action('init', array( $this, 'updater' ), 1);
	}
	
	/**
	 * Initialize License Updater.
	 * Load Updater initialize.
	 * @return void
	 */
	public function updater() {
		// Plugin Updater Code
		if(class_exists('WooVina_Plugin_Updater')) {
			$license = new WooVina_Plugin_Updater(__FILE__, 'WooVina Product Sharing', $this->version, 'WooVina Team');
		}
	}
	
	/**
	 * Main WooVina_Product_Sharing Instance
	 *
	 * Ensures only one instance of WooVina_Product_Sharing is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @see WooVina_Product_Sharing()
	 * @return Main WooVina_Product_Sharing instance
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) )
			self::$_instance = new self();
		return self::$_instance;
	} // End instance()

	/**
	 * Load the localisation file.
	 * @access  public
	 * @since   1.0.0
	 * @return  void
	 */
	public function wps_load_plugin_textdomain() {
		load_plugin_textdomain( 'woovina-product-sharing', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Cloning is forbidden.
	 *
	 * @since 1.0.0
	 */
	public function __clone() {
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?' ), '1.0.0' );
	}

	/**
	 * Unserializing instances of this class is forbidden.
	 *
	 * @since 1.0.0
	 */
	public function __wakeup() {
		_doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?' ), '1.0.0' );
	}

	/**
	 * Installation.
	 * Runs on activation. Logs the version number and assigns a notice message to a WordPress option.
	 * @access  public
	 * @since   1.0.0
	 * @return  void
	 */
	public function install() {
		$this->_log_version_number();
	}

	/**
	 * Log the plugin version number.
	 * @access  private
	 * @since   1.0.0
	 * @return  void
	 */
	private function _log_version_number() {
		// Log the version number.
		update_option( $this->token . '-version', $this->version );
	}

	/**
	 * Setup all the things.
	 * Only executes if WooVina or a child theme using WooVina as a parent is active and the extension specific filter returns true.
	 * @return void
	 */
	public function wps_setup() {
		$theme = wp_get_theme();

		if ( 'WooVina' == $theme->name || 'woovina' == $theme->template ) {
			require_once( $this->plugin_path .'/includes/helpers.php' );
			add_action( 'customize_register', array( $this, 'wps_customizer_register' ) );
			add_action( 'customize_preview_init', array( $this, 'wps_customize_preview_js' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'wps_get_style' ), 999 );
			add_action( 'woocommerce_after_single_product_summary', array( $this, 'wps_product_share' ) );
			add_filter( 'woovina_head_css', array( $this, 'wps_head_css' ) );
		}
	}

	/**
	 * Customizer Controls and settings
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	public function wps_customizer_register( $wp_customize ) {

		/**
	     * Add a new section
	     */
		$wp_customize->add_section( 'wps_product_sharing_section' , array(
		    'title'      	=> esc_html__( 'Product Sharing', 'woovina-product-sharing' ),
		    'priority'   	=> 210,
		) );

		/**
	     * Sharing sites
	     */
        $wp_customize->add_setting( 'wps_product_sharing_sites', array(
			'default'           	=> array( 'twitter', 'facebook', 'pinterest', 'email' ),
			'sanitize_callback' 	=> 'woovina_sanitize_multi_choices',
		) );

		$wp_customize->add_control( new WooVina_Customizer_Sortable_Control( $wp_customize, 'wps_product_sharing_sites', array(
			'label'	   				=> esc_html__( 'Sharing Buttons', 'woovina-product-sharing' ),
			'section'  				=> 'wps_product_sharing_section',
			'settings' 				=> 'wps_product_sharing_sites',
			'priority' 				=> 10,
			'choices' 				=> array(
				'twitter'  		=> 'Twitter',
				'facebook' 		=> 'Facebook',
				'pinterest' 	=> 'Pinterest',
				'email' 		=> 'Mail',
			),
		) ) );

		/**
	     * Borders color
	     */
        $wp_customize->add_setting( 'wps_product_sharing_borders_color', array(
			'default'			=> '#e9e9e9',
			'transport'			=> 'postMessage',
			'sanitize_callback' => 'woovina_sanitize_color',
		) );

		$wp_customize->add_control( new WooVina_Customizer_Color_Control( $wp_customize, 'wps_product_sharing_borders_color', array(
			'label'			=> esc_html__( 'Borders Color', 'woovina-product-sharing' ),
			'section'		=> 'wps_product_sharing_section',
			'settings'		=> 'wps_product_sharing_borders_color',
			'priority'		=> 10,
		) ) );

		/**
	     * Icons background color
	     */
        $wp_customize->add_setting( 'wps_product_sharing_icons_bg', array(
			'default'			=> '#333333',
			'transport'			=> 'postMessage',
			'sanitize_callback' => 'woovina_sanitize_color',
		) );

		$wp_customize->add_control( new WooVina_Customizer_Color_Control( $wp_customize, 'wps_product_sharing_icons_bg', array(
			'label'			=> esc_html__( 'Icons Background Color', 'woovina-product-sharing' ),
			'section'		=> 'wps_product_sharing_section',
			'settings'		=> 'wps_product_sharing_icons_bg',
			'priority'		=> 10,
		) ) );

		/**
	     * Icons color
	     */
        $wp_customize->add_setting( 'wps_product_sharing_icons_color', array(
			'default'			=> '#ffffff',
			'transport'			=> 'postMessage',
			'sanitize_callback' => 'woovina_sanitize_color',
		) );

		$wp_customize->add_control( new WooVina_Customizer_Color_Control( $wp_customize, 'wps_product_sharing_icons_color', array(
			'label'			=> esc_html__( 'Icons Color', 'woovina-product-sharing' ),
			'section'		=> 'wps_product_sharing_section',
			'settings'		=> 'wps_product_sharing_icons_color',
			'priority'		=> 10,
		) ) );

	}

	/**
	 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
	 */
	public function wps_customize_preview_js() {
		wp_enqueue_script( 'wps-customizer', plugins_url( '/assets/js/customizer.min.js', __FILE__ ), array( 'customize-preview' ), '1.0', true );
	}

	/**
	 * Enqueue style.
	 * @since   1.0.0
	 */
	public function wps_get_style() {

		// Load main stylesheet
		wp_enqueue_style( 'wps-product-share-style', plugins_url( '/assets/css/style.min.css', __FILE__ ) );

		// Load main script
		wp_enqueue_script( 'wps-product-share-script', plugins_url( '/assets/js/social.min.js', __FILE__ ), array( 'jquery' ), $this->version, true );

		// If rtl
		if ( is_RTL() ) {
			wp_enqueue_style( 'wps-product-share-rtl', plugins_url( '/assets/css/rtl.css', __FILE__ ) );
		}

	}

	/**
	 * Product sharing links
	 */
	public function wps_product_share() {

		$file 		= $this->plugin_path . 'template/product-share.php';
		$theme_file = get_stylesheet_directory() . '/templates/extra/product-share.php';

		if ( file_exists( $theme_file ) ) {
			$file = $theme_file;
		}

		if ( file_exists( $file ) ) {
			include $file;
		}

	}

	/**
	 * Add css in head tag.
	 */
	public function wps_head_css( $output ) {
		
		// Global vars
		$product_sharing_borders 		= get_theme_mod( 'wps_product_sharing_borders_color', '#e9e9e9' );
		$product_sharing_icons_bg 		= get_theme_mod( 'wps_product_sharing_icons_bg', '#333333' );
		$product_sharing_icons_color 	= get_theme_mod( 'wps_product_sharing_icons_color', '#ffffff' );

		// Define css var
		$css = '';

		// Add borders color
		if ( ! empty( $product_sharing_borders ) && '#e9e9e9' != $product_sharing_borders ) {
			$css .= '.woocommerce div.product .product-share,.woocommerce div.product .product-share ul li{border-color:'. $product_sharing_borders .';}';
		}

		// Add icon background
		if ( ! empty( $product_sharing_icons_bg ) && '#333333' != $product_sharing_icons_bg ) {
			$css .= '.woocommerce div.product .product-share ul li a .wps-icon-wrap{background-color:'. $product_sharing_icons_bg .';}';
		}

		// Add icon color
		if ( ! empty( $product_sharing_icons_color ) && '#ffffff' != $product_sharing_icons_color ) {
			$css .= '.woocommerce div.product .product-share ul li a .wps-icon-wrap .wps-icon{color:'. $product_sharing_icons_color .';}';
		}
			
		// Return CSS
		if ( ! empty( $css ) ) {
			$output .= '/* Extra CSS */'. $css;
		}

		// Return output css
		return $output;

	}	
} // End Class
