<?php
/**
 * Register Style & Scripts
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

// Start Class
if(! class_exists('WooVina_WVS_Register_Style_Scripts')) {

	class WooVina_WVS_Register_Style_Scripts {

		public function __construct() {
			add_action('wp_enqueue_scripts', array($this, 'register_my_scripts'));			
		}

		public function register_my_scripts() {
			global $post, $product;
		
			$displaytypenumber                  = 0;
			$wvs_swatch_tooltip     			= get_option('wvs_swatch_tooltip');
			$wvs_swatch_behaviour               = get_option('wvs_disable_unavailable_options','01');	   
			$iPod                               = stripos($_SERVER['HTTP_USER_AGENT'],"iPod");
			$iPhone                             = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
			$iPad                               = stripos($_SERVER['HTTP_USER_AGENT'],"iPad");
			$wvs_disableios_tooltip 			= get_option('wvs_disableios_tooltip');
			$wvs_show_selected_attribute_name 	= get_option('wvs_show_selected_attribute_name');

			if(isset($wvs_disableios_tooltip) && $wvs_disableios_tooltip == 'yes' && ($iPod || $iPhone || $iPad)) {
				$wvs_swatch_tooltip ='no';
			}

			if(isset($wvs_swatch_behaviour)	&& ($wvs_swatch_behaviour == '02')) {
				$wvs_disable_options = 'yes';
				$wvs_hide_options    = 'no';
			} elseif(isset($wvs_swatch_behaviour) && ($wvs_swatch_behaviour == '03')) {
				$wvs_disable_options = 'yes';
				$wvs_hide_options    = 'yes';
			} else {
				$wvs_disable_options = 'no';
				$wvs_hide_options    = 'no';
			}

			if(is_product() ) {
				$product            = wc_get_product($post->ID);
				$product_type       = $product->get_type();
				$displaytypenumber  = wvs_return_displaytype_number($product, $post);
			} elseif (! empty($post->post_content) && strstr($post->post_content, '[product_page')) {
				$product            = wc_get_product($post->ID);
				$product_type       = get_post_type($post->ID);
				$displaytypenumber  = wvs_return_displaytype_number($product, $post);
			}
	
			wp_register_style('wvs-frontend', 	WVS_PLUGIN_URL .'assets/css/front-end.css');
			wp_register_style('powerTip', 		WVS_PLUGIN_URL .'assets/css/powerTip.css');

			$goahead = 1;

			if(isset($_SERVER['HTTP_USER_AGENT'])){
				$agent = $_SERVER['HTTP_USER_AGENT'];
			}

			if(preg_match('/(?i)msie [5-8]/', $agent)) {
				$goahead = 0;
			}

			if(($displaytypenumber > 0) && ($goahead == 1)) {
				wp_register_script('product-frontend', WVS_PLUGIN_URL .'assets/js/product-frontend.js' ,array('jquery'), false, true);

				$wvs_localize = array(
					'tooltip'         => $wvs_swatch_tooltip,
					'disable_options' => $wvs_disable_options,
					'hide_options'    => $wvs_hide_options,
					'show_attribute'  => $wvs_show_selected_attribute_name,
					'quick_view'      => false
				);

				wp_localize_script('product-frontend', 'wvs', $wvs_localize);
				wp_register_script('powerTip', WVS_PLUGIN_URL .'assets/js/powerTip.js' ,array('jquery'), false, true);
			}

			if(((is_product()) && ($product_type == "variable")) || (! empty($post->post_content) && strstr($post->post_content, '[product_page'))) {
				if(($displaytypenumber > 0) && ($goahead == 1)) {
					wp_enqueue_script('product-frontend'); 
					wp_enqueue_style('wvs-frontend');

					if(isset($wvs_swatch_tooltip) && ($wvs_swatch_tooltip == 'yes')) {
						if(isset($wvs_disableios_tooltip) && $wvs_disableios_tooltip == 'yes' && ($iPod || $iPhone || $iPad)) {
							wp_deregister_script('powerTip');
							wp_deregister_style('powerTip');
						} else {
							wp_enqueue_script('powerTip');
							wp_enqueue_style('powerTip');
						}
					}
				}
			}
		}
	}
	
}

new WooVina_WVS_Register_Style_Scripts();