<?php
/**
 * Plugin Name:			WooVina Variation Swatches
 * Plugin URI:			https://woovina.com/extensions/woovina-variation-swatches/
 * Description:			A plugin provides a much nicer way to display variations of variable products.
 * Version:				1.2.5
 * Author:				WooVina
 * Author URI:			https://woovina.com/
 * Requires at least:	5.5.0
 * Tested up to:		5.7.1
 * Requires PHP:       	7.4
 *
 * Text Domain: woovina-variation-swatches
 * Domain Path: /languages/
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

/**
 * Returns the main instance of WooVina_Variation_Swatches to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return object WooVina_Variation_Swatches
 */
function WooVina_Variation_Swatches() {
	return WooVina_Variation_Swatches::instance();
} // End WooVina_Variation_Swatches()

WooVina_Variation_Swatches();


/**
 * Main WooVina_Variation_Swatches Class
 *
 * @class WooVina_Variation_Swatches
 * @version	1.0.0
 * @since 1.0.0
 * @package	WooVina_Variation_Swatches
 */
final class WooVina_Variation_Swatches {
	/**
	 * WooVina_Variation_Swatches The single instance of WooVina_Variation_Swatches.
	 * @var 	object
	 * @access  private
	 * @since 	1.0.0
	 */
	private static $_instance = null;

	/**
	 * The token.
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $token;

	/**
	 * The version number.
	 * @var     string
	 * @access  public
	 * @since   1.0.0
	 */
	public $version;
	
	// Admin - Start
	/**
	 * The admin object.
	 * @var     object
	 * @access  public
	 * @since   1.0.0
	 */
	public $admin;

	/**
	 * Constructor function.
	 * @access  public
	 * @since   1.0.0
	 * @return  void
	 */
	
	public function __construct() {
		$this->token 			= 'woovina-variation-swatches';
		$this->plugin_url 		= plugin_dir_url(__FILE__);
		$this->plugin_path 		= plugin_dir_path(__FILE__);
		$this->plugin_basename 	= plugin_basename(__FILE__);
		$this->version 			= '1.2.5';			
		
		define('WVS_PLUGIN_URL', $this->plugin_url);
		define('WVS_BASE_URL', $this->plugin_basename);
		define('WVS_PATH', $this->plugin_path);
		define('WVS_VERSION', $this->version);		
		define('WVS_PLACEHOLDER_IMG', WVS_PLUGIN_URL .'assets/images/placeholder.png');
		
		register_activation_hook(__FILE__, array($this, 'install'));

		add_action('init', array($this, 'load_plugin_textdomain'));
		add_action('init', array($this, 'setup'));
		add_action('init', array( $this, 'updater' ), 1);
	}
	
	/**
	 * Initialize License Updater.
	 * Load Updater initialize.
	 * @return void
	 */
	public function updater() {
		// Plugin Updater Code
		if(class_exists('WooVina_Plugin_Updater')) {
			$license = new WooVina_Plugin_Updater(__FILE__, 'WooVina Variation Swatches', $this->version, 'WooVina Team');
		}
	}
	
	/**
	 * Main WooVina_Variation_Swatches Instance
	 *
	 * Ensures only one instance of WooVina_Variation_Swatches is loaded or can be loaded.
	 *
	 * @since 1.0
	 * @static
	 * @see WooVina_Variation_Swatches()
	 * @return Main WooVina_Variation_Swatches instance
	 */
	public static function instance() {
		if(is_null(self::$_instance))
			self::$_instance = new self();
		return self::$_instance;
	} // End instance()
	
	/**
	 * Load the localisation file.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function load_plugin_textdomain() {
		load_plugin_textdomain('woovina-variation-swatches', false, dirname(plugin_basename(__FILE__)) .'/languages/');
	}
	
	/**
	 * Cloning is forbidden.
	 *
	 * @since 1.0
	 */
	public function __clone() {
		_doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?'), '1.0');
	}

	/**
	 * Unserializing instances of this class is forbidden.
	 *
	 * @since 1.0
	 */
	public function __wakeup() {
		_doing_it_wrong(__FUNCTION__, __('Cheatin&#8217; huh?'), '1.0');
	}

	/**
	 * Installation.
	 * Runs on activation. Logs the version number and assigns a notice message to a WordPress option.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function install() {
		$this->_log_version_number();
	}

	/**
	 * Log the plugin version number.
	 * @access  private
	 * @since   1.0
	 * @return  void
	 */
	private function _log_version_number() {
		// Log the version number.
		update_option($this->token .'-version', $this->version);
	}
	
	/**
	 * Setup all the things.
	 * Only executes if WooVina or a child theme using WooVina as a parent is active and the extension specific filter returns true.
	 * @return void
	 */
	public function setup() {
		$theme = wp_get_theme();

		if(class_exists('WooCommerce') && ('WooVina' == $theme->name || 'woovina' == $theme->template)) {
			require_once(WVS_PATH .'includes/classes/create_variations_metabox.php');
			require_once(WVS_PATH .'includes/classes/override_woocommerce_variable_template.php');
			require_once(WVS_PATH .'includes/classes/register_scripts_styles.php');
			require_once(WVS_PATH .'includes/classes/attribute_global_values.php');
			require_once(WVS_PATH .'includes/classes/shop_page_swatchs.php');
			
			require_once(WVS_PATH .'includes/common_functions.php');
			require_once(WVS_PATH .'includes/swatch_form_fields.php');
			require_once(WVS_PATH .'includes/direct_variation_link.php');
			require_once(WVS_PATH .'includes/add_layered_navigation_widget.php');
			require_once(WVS_PATH .'includes/admin/add_plugin_settings_field.php');
		}
	}	
}
