<?php
/**
 * Metabox
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

// Start Class
if(! class_exists('WooVina_WVS_Metabox')) {

	class WooVina_WVS_Metabox {
		/**
		 * Start things up
		 */
		public function __construct() {
			add_action('admin_enqueue_scripts', 				array($this, 'register_scripts'));
			add_action('woocommerce_product_write_panel_tabs', 	array($this, 'add_colored_variable_metabox'));
			add_action('woocommerce_product_data_panels', 		array($this, 'colored_variable_tab_options'));
			add_action('woocommerce_process_product_meta', 		array($this, 'process_product_meta_colored_variable_tab'), 10, 2);
		}
		
		public function register_scripts() {
			wp_register_script('wvs-meta', 				WVS_PLUGIN_URL .'assets/js/wvs-meta.js');
			wp_register_script('jquery.accordion', 		WVS_PLUGIN_URL .'assets/js/jquery.accordion.js');
			wp_register_script('wvs-iris', 				WVS_PLUGIN_URL .'assets/js/iris.min.js');			
			wp_register_style('wvs-variation-metabox', 	WVS_PLUGIN_URL .'assets/css/wvs-variation-metabox.css');
			
			$translation_array = array(
				'uploadimage'    => __('Choose an image' , 'woovina-variation-swatches'),
				'useimage'       => __('Use Image' , 'woovina-variation-swatches'),
				'placeholder'    => WVS_PLACEHOLDER_IMG,
			);
			
			wp_localize_script('wvs-meta', 'wvsmeta', $translation_array);
		}
		
		public function add_colored_variable_metabox() {
		?>
		<li class="colored_variable_tab show_if_variable"><a href="#colored_variable_tab_data">&nbsp;&nbsp;<?php _e('WooVina Variation Swatches', 'woovina-variation-swatches'); ?></a></li>
		<?php }
		
		public function colored_variable_tab_options() {
			global $post,$woocommerce;

			$_coloredvariables        =  get_post_meta($post->ID, '_coloredvariables', true);
			$shop_swatches            =  get_post_meta($post->ID, '_shop_swatches', true);
			$shop_swatches_attribute  =  get_post_meta($post->ID, '_shop_swatches_attribute', true);
			$helpimg                  =  WVS_PLUGIN_URL .'assets/images/help.png';

			wp_enqueue_script('wvs-iris');
			wp_enqueue_script('wvs-meta');
			wp_enqueue_script('jquery.accordion');
			
			wp_enqueue_style('wvs-variation-metabox');
			wp_enqueue_style('jquery.accordion');
			wp_enqueue_style('jquery.accordion');

			wp_enqueue_media();

			include(WVS_PATH .'includes/forms/variation_select_tab_content.php');
		}
		
		public function process_product_meta_colored_variable_tab($post_id) {
			$shop_swatches = isset($_POST['shop_swatches']) ? 'yes' : 'no';

			if(isset($_POST['coloredvariables'])) update_post_meta($post_id, '_coloredvariables', $_POST['coloredvariables']);

			if(isset($shop_swatches)) update_post_meta($post_id, '_shop_swatches', $shop_swatches);

			if(isset($_POST['shop_swatches_attribute'])) update_post_meta($post_id, '_shop_swatches_attribute', $_POST['shop_swatches_attribute']);
		}
	}
}

new WooVina_WVS_Metabox();