<?php
/**
 * Plugin Name:			WooVina Preloader
 * Plugin URI:			https://woovina.com/extensions/woovina-preloader
 * Description:			WooVina Preloader is simple CSS spinners and throbbers made with CSS and minimal HTML markup.
 * Version:				2.0.1
 * Author:				WooVina
 * Author URI:			https://woovina.com/
 * Requires at least:	5.0.0
 * Tested up to:		5.7.1
 * Requires PHP:       	7.4
 *
 * Text Domain: woovina-preloader
 * Domain Path: /languages/
 *
 * @package WooVina_Preloader
 * @category Extend
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

/**
 * Returns the main instance of WooVina_Preloader to prevent the need to use globals.
 *
 * @since 1.0
 * @return object WooVina_Preloader
 */
function WooVina_Preloader() {
	return WooVina_Preloader::instance();
} // End WooVina_Preloader()

WooVina_Preloader();

/**
 * Main WooVina_Preloader Class
 *
 * @class WooVina_Preloader
 * @version	1.0
 * @since 1.0
 * @package	WooVina_Preloader
 */
final class WooVina_Preloader {
	
	/**
	 * WooVina_Preloader The single instance of WooVina_Preloader.
	 * @var 	object
	 * @access  private
	 * @since 	1.0
	 */
	private static $_instance = null;
	
	/**
	 * The token.
	 * @var     string
	 * @access  public
	 * @since   1.0
	 */
	public $token;
	
	/**
	 * The options.
	 * @var     string
	 * @access  private
	 * @since   1.0
	 */
	private $options;
	
	/**
	 * Constructor function.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	
	public function __construct() {
		
		global $pagenow;
		
		$this->token 			= 'woovina-preloader';
		$this->plugin_url 		= plugin_dir_url(__FILE__);
		$this->plugin_path 		= plugin_dir_path(__FILE__);
		$this->version 			= '2.0.1';
		
		define('WVP_URL', $this->plugin_url);
		define('WVP_PATH', $this->plugin_path);
		define('WVP_VERSION', $this->version);
		
		register_activation_hook(__FILE__, array($this, 'install'));		
		
		// Don't load preloader when edit page with Elementor
		if(isset($_GET['elementor-preview']) || 'themes.php' == $pagenow) {
			return;
		}
		
		add_action('init', array($this, 'load_plugin_textdomain'));
		add_action('admin_menu', array($this, 'add_submenu_option'));
		add_action('admin_init', array($this, 'register_settings'));

		add_filter('wp_enqueue_scripts', array($this, 'enqueue_styles'), 0);
		add_action('admin_enqueue_scripts', array($this, 'enqueue_styles'));

		add_filter('woovina_before_outer_wrap', array($this, 'load_preloader_html'));
		
		add_action('init', array( $this, 'updater' ), 1);
	}
	
	
	/**
	 * Main WooVina_Preloader Instance
	 *
	 * Ensures only one instance of WooVina_Preloader is loaded or can be loaded.
	 *
	 * @since 1.0
	 * @static
	 * @see WooVina_Preloader()
	 * @return Main WooVina_Preloader instance
	 */
	public static function instance() {
		if(is_null(self::$_instance))
			self::$_instance = new self();
		return self::$_instance;
	} // End instance()
	
	
	/**
	 * Installation.
	 * Runs on activation. Logs the version number and assigns a notice message to a WordPress option.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function install() {
		update_option($this->token . '-version', $this->version);
	}
	
	/**
	 * UnInstallation.
	 * Delete options after uninstall
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function uninstall() {
		delete_option('wvp-loader-opt');
	}
	
	/**
	 * Initialize License Updater.
	 * Load Updater initialize.
	 * @return void
	 */
	public function updater() {
		// Plugin Updater Code
		if(class_exists('WooVina_Plugin_Updater')) {
			$license = new WooVina_Plugin_Updater(__FILE__, 'WooVina Preloader', $this->version, 'WooVina Team');
		}
	}
	
	/**
	 * Load the localisation file.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function load_plugin_textdomain() {
		load_plugin_textdomain('woovina-preloader', false, dirname(plugin_basename(__FILE__)) . '/languages/');
	}
	
	
	/**
	 * Add Submenu Option.
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function add_submenu_option(){
		// Set plugin only work with WooVina theme or child theme.
		$theme = wp_get_theme();
		
		if('WooVina' == $theme->name || 'woovina' == $theme->template) {
			add_submenu_page( 
				'woovina-panel', // parent slug
				__('WooVina Preloader', 'woovina-preloader'), // page title
				__('Preloader', 'woovina-preloader'), // menu title
				'manage_options', // capability
				'wvp-loader', // menu slug
				array($this, 'submenu_callback_fn') // Callback
			);
		} 
		else {
			add_submenu_page( 
				'options-general.php', // parent slug
				__('WooVina Preloader', 'woovina-preloader'), // page title
				__('Preloader', 'woovina-preloader'), // menu title
				'manage_options', // capability
				'wvp-loader', // menu slug
				array($this, 'submenu_callback_fn') // Callback
			);
		}
	}
	
	/**
	 * Load Preloader HTML Code
	 * @access  public
	 * @since   1.0
	 * @return  array
	 */
	public function load_preloader_html() {
		$wvp   = get_option('wvp-loader-opt');		
		$html  = '<div class="woovina-loader wvp-loader-one">Loading...</div>';
		$style = @$wvp['loader'];
		
		switch ($style) {
			case "Preloader Style 1":
				$html = '<div class="woovina-loader wvp-loader-one">Loading...</div>';
			break;
			
			case "Preloader Style 2":
				$html = '<div class="woovina-loader wvp-loader-two"><span></span><span></span><span></span><span></span></div>';
			break;
			
			case "Preloader Style 3":
				$html = '<div class="woovina-loader wvp-loader-three"><span></span><span></span><span></span><span></span><span></span></div>';
			break;
			
			case "Preloader Style 4":
				$html = '<div class="woovina-loader wvp-loader-four"><span class="spinner-cube spinner-cube1"></span><span class="spinner-cube spinner-cube2"></span><span class="spinner-cube spinner-cube3"></span><span class="spinner-cube spinner-cube4"></span><span class="spinner-cube spinner-cube5"></span><span class="spinner-cube spinner-cube6"></span><span class="spinner-cube spinner-cube7"></span><span class="spinner-cube spinner-cube8"></span><span class="spinner-cube spinner-cube9"></span></div>';
			break;
			
			case "Preloader Style 5":
				$html = '<div class="woovina-loader wvp-loader-five"><span class="spinner-cube-1 spinner-cube"></span><span class="spinner-cube-2 spinner-cube"></span><span class="spinner-cube-4 spinner-cube"></span> <span class="spinner-cube-3 spinner-cube"></span></div>';
			break;
			
			case "Preloader Style 6":
				$html = '<div class="woovina-loader wvp-loader-six"><span class="spinner-cube-1 spinner-cube"></span><span class="spinner-cube-2 spinner-cube"></span></div>';
			break;
			
			case "Preloader Style 7":
				$html = '<div class="woovina-loader wvp-loader-seven"><div class="box1"></div><div class="box2"></div><div class="box3"></div></div>';
			break;
			
			case "Preloader Style 8":
				$html = '<div class="woovina-loader wvp-loader-eight"><svg><g><path d="M 50,100 A 1,1 0 0 1 50,0"/></g><g><path d="M 50,75 A 1,1 0 0 0 50,-25"/></g><defs><linearGradient id="gradient" x1="0%" y1="0%" x2="0%" y2="100%"><stop offset="0%" style="stop-color:#FF56A1;stop-opacity:1" /><stop offset="100%" style="stop-color:#f68e13;stop-opacity:1" /></linearGradient></defs></svg></div>';
			break;
			
			case "Preloader Style 9":
				$html = '<div class="woovina-loader wvp-loader-nine"><span></span><span></span><span></span></div>';
			break;
			
			case "Preloader Style 10":
				$html = '<div class="woovina-loader wvp-loader-ten"><div class="blob-1"></div><div class="blob-2"></div></div>';
			break;
			
			case "Preloader Style 11":
				$html = '<div class="woovina-loader wvp-loader-eleven"><div class="eleven-spinner"></div></div>';
			break;
			
			case "Preloader Style 12":
				$html = '<div class="woovina-loader wvp-loader-twelve"><div class="twelve-spinner"></div></div>';
			break;
			
			case "Preloader Style 13":
				$html = '<div class="woovina-loader wvp-loader-thirteen"><div class="thirteen-spinner"></div><div class="thirteen-spinner"></div></div>';
			break;
			
			default: 
				$html = '<div class="woovina-loader wvp-loader-one">Loading...</div>';
			break;
		}
		
		if(isset($wvp['homepage']) && $wvp['homepage'] == "1") {
			if(is_home() || is_front_page()) {
				echo '<div class="woovina-page-loader">' . $html . '</div>';
			}
		} 
		else {
			echo '<div class="woovina-page-loader">' . $html . '</div>';
		}
	}
	
	/**
	 * Callback function of option page
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function submenu_callback_fn(){
		// Set class property
	      $this->options = get_option('wvp-loader-opt');
	     
	      ?>
	      <div id="woovina-preloader-wrapper" class="wrap">	              
	          <form method="post" action="options.php">
	          <?php
	              // This prints out all hidden setting fields
	              settings_fields('wvp_loader'); //option group

	              do_settings_sections('wvp-loader'); // option name

	              submit_button(); 
	          ?>
	          </form>
	      </div>
      <?php
	}
	
	

	/**
	 * Register setting fields
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function register_settings(){
		// Register the settings with Validation callback
		register_setting( 
			'wvp_loader', // option group
			'wvp-loader-opt', // option name
			array($this, 'wvp_sanitize') // sanitize 
		);
		
		add_settings_section(
			'wvp_loader_id', // ID
			__('WooVina Preloader', 'woovina-preloader'), // Title
			array( $this, 'wvp_section_info'), // Callback			             
			'wvp-loader' // Page (same as submenu page menu_slug)
		);  
		
		add_settings_field(
			'wvp-loader-select', // ID
			__('Select Preloader Style', 'woovina-preloader'), // Title 
			array($this, 'wvp_preloader_list'), // Callback
			'wvp-loader', // Page (same as submenu page menu_slug)
			'wvp_loader_id' // Section id
		);
				
		add_settings_field(
			'wvp-loader-home-page', // ID
			__('Show only on Home Page', 'woovina-preloader'),  // Title
			array($this, 'wvp_preloader_homepage'),  //callback
			'wvp-loader', // Page (same as submenu page menu_slug)
			'wvp_loader_id' // Section id
		);

		add_settings_field(
			'wvp_loader_duration', // ID
			__('Duration to show Loader (ms)', 'woovina-preloader'), // Title
			array($this, 'wvp_loader_delay'), // Callback
			'wvp-loader', // Page (same as submenu page menu_slug)
			'wvp_loader_id' // Section id
		);

		add_settings_field(
			'wvp_loader_fadeout', // ID
			__('Loader to Fade Out (ms)', 'woovina-preloader'), // Title
			array($this, 'wvp_loader_fadeOut'), // Callback
			'wvp-loader', // Page (same as submenu page menu_slug)
			'wvp_loader_id' // Section id
		);
	}
	
	
	/**
	 * Preloader List Values
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_preloader_list(){
		// wvp-loader-opt

		$loader = array(
			__('Preloader Style 1', 'woovina-preloader'), 
			__('Preloader Style 2', 'woovina-preloader'),
			__('Preloader Style 3', 'woovina-preloader'),
			__('Preloader Style 4', 'woovina-preloader'),
			__('Preloader Style 5', 'woovina-preloader'),
			__('Preloader Style 6', 'woovina-preloader'),
			__('Preloader Style 7', 'woovina-preloader'),
			__('Preloader Style 8', 'woovina-preloader'),
			__('Preloader Style 9', 'woovina-preloader'),
			__('Preloader Style 10', 'woovina-preloader'),
			__('Preloader Style 11', 'woovina-preloader'),
			__('Preloader Style 12', 'woovina-preloader'),
			__('Preloader Style 13', 'woovina-preloader'),
		);

		$select  = "<select id='loader-img' name='wvp-loader-opt[loader]'>";
		$select .= "<option value=''>" . __('Select Loader', 'woovina-preloader') . "</option>";
		foreach($loader as $load){
			$sel = ( isset( $this->options['loader'] ) && $this->options['loader'] == $load ) ? 'selected="selected"' : '';
			$select .= '<option value="'.$load.'" '.$sel.'>'.$load.'</option>';
		}
		$select .= "</select><div class='wvp-loader-block'><div class='wvp-loader-table'><div id='loader-preview'> <span>" . __('Loading...', 'woovina-preloader') . "</span> </div></div></div>";
		
		_e($select, "woovina-preloader");
	}

	
	/**
	 * Setting function for home page
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_preloader_homepage(){
		printf(__('<input type="checkbox" name="%s" value="1" %s /> (Preloader will only show on Home Page)','woovina-preloader'), "wvp-loader-opt[homepage]", (isset($this->options['homepage']) && $this->options['homepage'] == "1") ? 'checked="checked"' : '' );
	}
 
	
	/**
	 * Setting function fadeout
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_loader_fadeOut(){
		printf(__('<input type="text" name="%s" value="%s" class="text-field" /><div>%s</div>','woovina-preloader'),"wvp-loader-opt[fadeout]", (isset($this->options['fadeout']) ) ? $this->options['fadeout'] : '',__('Default: 2500 (1 second => 1000 ms)', "woovina-preloader"));
	}


	/**
	 * Setting function delay
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_loader_delay(){
		printf(__('<input type="text" name="%s" value="%s"  class="text-field" /><div>%s</div>','woovina-preloader'), "wvp-loader-opt[delay]", (isset($this->options['delay']) ) ? $this->options['delay'] : '', __('Default: 1500 (1 second => 1000 ms)', "woovina-preloader") );
	}

	
	/**
	 * Sanitize function for setting
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_sanitize($input){
	 	foreach($input as $k => $v) {
		   $newinput[$k] = trim($v);
		   
		   	// Check the input is a letter or a number
		   	if(!preg_match('/^[A-Z0-9 _]*$/i', $v)) {
		    	$newinput[$k] = '';
		   	}
	 	}
		return $input;
	}


	/**
	 * Function for section info
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function wvp_section_info(){
		_e('<h3>WooVina Preloader Setting:</h3>', 'woovina-preloader');
	}
	
	
	/**
	 * Function load styles
	 * @access  public
	 * @since   1.0
	 * @return  void
	 */
	public function enqueue_styles($hook_suffix){

        if(is_admin()) {
        	if('theme-panel_page_wvp-loader' == $hook_suffix || 'settings_page_wvp-loader' == $hook_suffix) {
	            wp_register_script('wvp-admin-script', WVP_URL . 'assets/js/wvp-admin-script.js' , array('jquery'), WVP_VERSION );
	            wp_enqueue_script('wvp-admin-script');
        	}

            wp_register_style('wvp-admin-style', WVP_URL . 'assets/css/wvp-admin-preloader.css', false, WVP_VERSION);
            wp_enqueue_style('wvp-admin-style');

        } 
		else {

            wp_register_style('wvp-main-style', WVP_URL . 'assets/css/wvp-front-preloader.css', false, WVP_VERSION);
            wp_enqueue_style('wvp-main-style');

            wp_register_script('wvp-main-script', WVP_URL . 'assets/js/wvp-main-script.js' , array('jquery'), WVP_VERSION);
            wp_enqueue_script('wvp-main-script');

            // Localize the script with new data
            $localized_array = get_option('wvp-loader-opt');
            wp_localize_script('wvp-main-script', 'wvp_obj', $localized_array);

        }
        
        wp_register_style('wvp-style', WVP_URL . 'assets/css/wvp-preload-style.css', false, WVP_VERSION);
        wp_enqueue_style('wvp-style');
	}	
}