<?php
/**
 * Override Template
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

// Start Class
if(! class_exists('WooVina_WVS_Override_Template')) {
	
	class WooVina_WVS_Override_Template {

		public function __construct() {
			if(isset($_GET['action']) && 'woovina_product_quick_view' == $_GET['action']) return;
			add_action('woocommerce_locate_template', array(&$this, 'override_default_variable_template'), 10, 3);
		}
		
		public function override_default_variable_template($template, $template_name, $template_path) {
			global $woocommerce, $post, $product;
			
			$displaytypenumber 	= 0;
			$displaytypenumber 	= wvs_return_displaytype_number($product, $post);
			$goahead			= 1;

			if(isset($_SERVER['HTTP_USER_AGENT'])) {
				$agent = $_SERVER['HTTP_USER_AGENT'];
			}

			if(preg_match('/(?i)msie [5-8]/', $agent)) {
				$goahead=0;
			}

			if(($goahead == 1) && strstr($template, 'variable.php') && ($displaytypenumber > 0)) {
				$template = WVS_PATH .'/woocommerce/single-product/add-to-cart/variable.php';
			}
			
			return $template;
		}
	}  
}

new WooVina_WVS_Override_Template();