<?php
/**
 * Settings
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

// Start Class
if(! class_exists('WooVina_WVS_Settings')) {

	class WooVina_WVS_Settings {
		/**
		 * Start things up
		 */
		public function __construct() {
			add_filter('plugin_action_links_'. WVS_BASE_URL , 		array($this, 'add_action_links'));
			add_filter('woocommerce_settings_tabs_array', 			array($this, 'add_settings_tab'), 50);
			add_action('woocommerce_settings_tabs_wvs_settings', 	array($this, 'settings_tab'));
			add_action('woocommerce_update_options_wvs_settings', 	array($this, 'update_settings'));
			add_action('woocommerce_admin_field_wvs_global', 		array($this, 'global_settings'));
			add_action('admin_enqueue_scripts', 					array($this, 'admin_scripts'));
		}
		
		public static function admin_scripts() {
			if((isset($_GET['page']) && ($_GET['page'] == "wc-settings")) && (isset($_GET['tab']) && ($_GET['tab'] == "wvs_settings"))) {
				 wp_register_script('wvs-admin', WVS_PLUGIN_URL .'assets/js/wvs_admin.js' , array('jquery'), false, true);
				 wp_enqueue_script('wvs-admin');
			}
		}
		
		public static function add_action_links($links) {
			$mylinks = array(
				'<a href="'. admin_url('/admin.php?page=wc-settings&tab=wvs_settings') .'">Settings</a>',
			);
			return array_merge($links, $mylinks);
		}

		public static function add_settings_tab($settings_tabs) {
			$settings_tabs['wvs_settings'] = __('Variation Swatches', 'woovina-variation-swatches');
			return $settings_tabs;
		}
	  
		public static function settings_tab() {
			woocommerce_admin_fields(self::register_settings());
		}

		public static function update_settings() {
			woocommerce_update_options(self::register_settings());
		}

		public static function register_settings() {
			$settings = array(
				array(
					'name'     => __('WooVina Variation Swatches Settings', 'woovina-variation-swatches'),
					'type'     => 'title',
					'desc'     => '',
					'id'       => 'wc_wvs_settings_section'
				),

				array(
					'name'     => __('Clear selection text', 'woovina-variation-swatches'),
					'desc_tip' => __('This will replace the custom Clear selection text.', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_custom_clear_text',
					'type'     => 'text',
					'css'      => 'width:300px;',
					'default'  => 'Clear selection' 
				),

				array(
					'name'     => __('Product page custom swatches height', 'woovina-variation-swatches'),
					'desc_tip' => __('Custom swatch height on product page.you will need to chose custom as display type in variation select tab.', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_custom_swatch_height',
					'type'     => 'text',
					'css'      => 'width:35px;',
					'default'  => '32', 
					'desc'     => 'px'
				),
				
				array(
					'name'     => __('Product page custom swatches width', 'woovina-variation-swatches'),
					'desc_tip' => __('Custom swatch height on product page.you will need to chose custom as display type in variation select tab.', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_custom_swatch_width',
					'type'     => 'text',
					'css'      => 'width:35px;',
					'default'  => '32', 
					'desc'     => 'px'
				),
				
				array(
					'name'     => __('Enable tooltip on swatches', 'woovina-variation-swatches'),
					'id'       => 'wvs_swatch_tooltip',
					'type'     => 'hidden',
					'default'  => 'no'
				),

				array(
					'name'     => __('Disable tooltip on iOS devices', 'woovina-variation-swatches'),
					'id'       => 'wvs_disableios_tooltip',
					'type'     => 'hidden',
					'default'  => 'no'
				),
				
				array(
					'name'     => __('Show selected attribute name on single product page', 'woovina-variation-swatches'),
					'id'       => 'wvs_show_selected_attribute_name',
					'type'     => 'checkbox',
					'default'  => 'yes'
				),
				
				array(
					'name'     => __('Enable shop swatches slider', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_enable_shop_slider',
					'type'     => 'checkbox',
					'default'  => 'yes'
				),

				array(
					'name'     => __('Number of swatches to show in shop slider', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_shop_slider_number',
					'type'     => 'number',
					'css'      => 'width:60px;',
					'default'  => '4'
				),

				array(
					'name'     => __('Limit display of number of swatches on single product page', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_enable_shop_show_more',
					'type'     => 'checkbox',
					'default'  => 'yes',
					'desc_tip' => __('Check this if you have lot of options for attribute and you only want to show some them while there will a show more link which shows all options.', 'woovina-variation-swatches'),
				),

				array(
					'name'     => __('Number of swatches to show', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_show_swatches_number',
					'type'     => 'number',
					'css'      => 'width:60px;',
					'default'  => '5'
				),

				array(
					'name'     => __('Show more text', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_show_more_text',
					'type'     => 'text',
					'css'      => 'width:300px;',
					'default'  => '+ {remaining_count} more', 
					'desc_tip' => __('{remaining_count} - number of swatches that will show upon clicking show more button.', 'woovina-variation-swatches'),
				),

				array(
					'title'    => __('Shop swatches location', 'woovina-variation-swatches'),
					'desc'     => __('This controls location of shop swatches on shop/category/archive pages.', 'woocommerce'),
					'id'       => 'woocommerce_shop_swatches_display',
					'class'    => 'chosen_select',
					'css'      => 'min-width:300px;',
					'default'  => '01',
					'type'     => 'select',
					'options'  => array(
						'01'   => __('Before Archive Product Image', 'woovina-variation-swatches'),
						'02'   => __('After Archive Product Image', 'woovina-variation-swatches'),
						'03'   => __('Before Archive Product Title', 'woovina-variation-swatches'),
						'04'   => __('After Archive Product Title', 'woovina-variation-swatches'),
						'05'   => __('Before Archive Product Price', 'woovina-variation-swatches'),
						'06'   => __('After Archive Product Price', 'woovina-variation-swatches'),
						'07'   => __('Before Archive Product Button', 'woovina-variation-swatches'),
						'08'   => __('After Archive Product Button', 'woovina-variation-swatches'),
					),
				),

				array(
					'title'    => __('Shop hover image size', 'woovina-variation-swatches'),
					'desc'     => __('This controls size of hover image on shop/category/archive pages.', 'woocommerce'),
					'id'       => 'woocommerce_hover_imaga_size',
					'class'    => 'chosen_select',
					'css'      => 'min-width:300px;',
					'default'  => 'shop_catalog',
					'type'     => 'select',
					'options'  => array(
						'shop_catalog'   => __('Shop catalog size', 'woovina-variation-swatches'),
						'thumbnail'      => __('Thumbnail size', 'woovina-variation-swatches'),
						'medium'         => __('Medium Size', 'woovina-variation-swatches'),
						'large'          => __('Full Size', 'woovina-variation-swatches'),
					),
				),

				array(
					'title'    => __('Unavailable options behavior', 'woovina-variation-swatches'),
					'id'       => 'wvs_disable_unavailable_options',
					'class'    => 'chosen_select',
					'css'      => 'min-width:300px;',
					'default'  => '01',
					'type'     => 'select',
					'options'  => array(
						'01'   => __('Default - do not disable or hide unavailable options', 'woovina-variation-swatches'),
						'02'   => __('Disable unavailable options', 'woovina-variation-swatches'),
						'03'   => __('Hide unavailable options', 'woovina-variation-swatches')
					),
				),

				array(
					'name'     => __('Shop swatches height', 'woovina-variation-swatches'),
					'desc_tip' => __('Swatches height on shop page.', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_shop_swatch_height',
					'type'     => 'text',
					'css'      => 'width:35px;',
					'default'  => '32', 
					'desc'     => 'px'
				),
				
				array(
					'name'     => __('Shop swatches width', 'woovina-variation-swatches'),
					'desc_tip' => __('Swatches width on shop page.', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_shop_swatch_width',
					'type'     => 'text',
					'css'      => 'width:35px;',
					'default'  => '32', 
					'desc'     => 'px'
				),
				
				array(
					'name'     => __('Replace hover with click on mobile devices', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_wvs_disable_mobile_hover',
					'type'     => 'checkbox',
					'default'  => 'no'
				),
				
				array(
					'name'     => __('Enable direct variation link', 'woovina-variation-swatches'),
					'id'       => 'woocommerce_shop_swatch_link',
					'type'     => 'checkbox',
					'default'  => 'no', 
					'desc_tip'     => 'Plugin uses inbuilt direct variation link feature.No need to use any third party plugin for this.'
				),
				
				array(
					'name'     => __('Enable default attribute options', 'woovina-variation-swatches'),
					'id'       => 'wvs_woocommerce_global_activation',
					'type'     => 'checkbox',
					'default'  => 'no', 
					'desc_tip' => 'if enabled all those product attributes which does not have display type set under variation select tab will inherit the display type value from below given "default attribute options" table.you will still be able to override the value on product edit page.'
				),

				array(					
					'type'     => 'wvs_global',
					'id'       => 'wvs_global'
				),

				'section_end' => array(
					'type' 	=> 'sectionend',
					'id' 	=> 'wc_wvs_settings_section'
				)
			);
		
			return apply_filters('wc_wvs_settings_settings', $settings);
		}
		
		function global_settings() {
			$attribute_taxonomies = wc_get_attribute_taxonomies();
			$global_activation    = get_option("wvs_woocommerce_global_activation");
			$wvs_global           = get_option("wvs_global");
			
			if(isset($global_activation) && ($global_activation == 'yes')) :
	   ?>
		<tr valign="top">
			<th scope="row" class="titledesc"><?php _e('Default attribute options', 'woovina-variation-swatches') ?></th>
			<td class="forminp">
				<table class="widefat wp-list-table" cellspacing="0">
					<thead>
						<tr>
							<th width="15%" class="name">&emsp;<?php _e('Attribute', 'woovina-variation-swatches'); ?></th>
							<th>&emsp;<?php _e('Display Type', 'woovina-variation-swatches'); ?></th>
							<th width="40%">&emsp;<?php _e('Size', 'woovina-variation-swatches'); ?></th>
							<th>&emsp;<?php _e('Show Name', 'woovina-variation-swatches'); ?></th>
							<th></th>
						</tr>
					</thead>
					<tbody>
						<?php if((!empty($attribute_taxonomies)) && (sizeof($attribute_taxonomies) >0)) : ?>
							<?php foreach($attribute_taxonomies as $value) : ?>
							<?php $value           = json_decode(json_encode($value), true); ?>
							<?php $attribute_name  = $value['attribute_name']; ?>
							<?php $global_attribute_name  = 'pa_'.$value['attribute_name'].''; ?>
							<tr>
								<td width="15%" class="name">&emsp;
									<span class="name"><?php echo $attribute_name; ?></span>
								</td>
								<td class="status">
									 <select name="wvs_global[pa_<?php echo $attribute_name; ?>][display_type]">
										 <option value="none"><span class="wvsformfield"><?php _e('Dropdown Select', 'woovina-variation-swatches'); ?></span></option>
										 <option value="colororimage" <?php if((isset($wvs_global[$global_attribute_name]['display_type'])) && ($wvs_global[$global_attribute_name]['display_type'] == "colororimage")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Color or Image', 'woovina-variation-swatches'); ?></span></option>
										 <?php echo apply_filters('wvs_global_attribute_display_type', $global_attribute_name); ?>
									 </select>
								</td>
								<td width="40%">
									<select name="wvs_global[pa_<?php echo $attribute_name; ?>][size]">
									  <option value="small"  <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "small")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Small (32px * 32px)', 'woovina-variation-swatches'); ?></span></option>
									  
									  <option value="extrasmall" <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "extrasmall")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Extra Small (22px * 22px)', 'woovina-variation-swatches'); ?></span></option>
									  
									  <option value="medium" <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "medium")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Middle (40px * 40px)', 'woovina-variation-swatches'); ?></span></option>
									 
									  <option value="big" <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "big")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Big (60px * 60px)', 'woovina-variation-swatches'); ?></span></option>
									  
									  <option value="extrabig" <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "extrabig")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Extra Big (90px * 90px)', 'woovina-variation-swatches'); ?></span></option>
									  
									  <option value="custom" <?php if((isset($wvs_global[$global_attribute_name]['size'])) && ($wvs_global[$global_attribute_name]['size'] == "custom")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Custom', 'woovina-variation-swatches'); ?></span></option>
									  <?php echo apply_filters('wvs_global_attribute_display_size', $global_attribute_name); ?>
									 </select>
									 <select name="wvs_global[pa_<?php echo $attribute_name; ?>][displaytype]">
									 
									   <option value="square" <?php if((isset($wvs_global[$global_attribute_name]['displaytype'])) && ($wvs_global[$global_attribute_name]['displaytype'] == "square")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Square', 'woovina-variation-swatches'); ?></span></option>
									   
									   <option value="round" <?php if((isset($wvs_global[$global_attribute_name]['displaytype'])) && ($wvs_global[$global_attribute_name]['displaytype'] == "round")) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Round', 'woovina-variation-swatches'); ?></span></option>
										
									   <?php echo apply_filters('wvs_global_attribute_display_displaytype', $global_attribute_name); ?>
									  </select>
								</td>
								<td>
								   <select name="wvs_global[pa_<?php echo $attribute_name; ?>][show_name]" class="wvsdisplaytype">
									   <option value='no' <?php if((isset($wvs_global[$global_attribute_name]['show_name'])) && ($wvs_global[$global_attribute_name]['show_name'] == 'no')) {echo "selected";} ?>><span class="wvsformfield"><?php _e('No', 'woovina-variation-swatches'); ?></span></option>
									   <option value='yes' <?php if((isset($wvs_global[$global_attribute_name]['show_name'])) && ($wvs_global[$global_attribute_name]['show_name'] == 'yes')) {echo "selected";} ?>><span class="wvsformfield"><?php _e('Yes', 'woovina-variation-swatches'); ?></span></option>
								   </select>
								</td>
								<td>
									<a href="edit-tags.php?taxonomy=<?php echo wc_attribute_taxonomy_name($attribute_name); ?>&amp;post_type=product" class="button alignright configure-terms"><?php _e('Set color/images', 'woovina-variation-swatches'); ?></a>
								</td>
							</tr>
							<?php endforeach; ?>
	                    <?php endif;?>
					</tbody>
				</table>
			</td>
		</tr>
	<?php 
		endif;
		}
	}
}	

new WooVina_WVS_Settings();
