<?php
/**
 * Global Attribute
 *
 * @package WooVina_Variation_Swatches
 * @category Core
 * @author WooVina
 */

// Exit if accessed directly
if(! defined('ABSPATH')) {
	exit;
}

// Start Class
if(! class_exists('WooVina_WVS_Global_Attribute')) {
 
	class WooVina_WVS_Global_Attribute {
		
		public function __construct() {
			add_action('admin_init', 			array($this, 	'setup_texonomy_based_fields'));
			add_action('created_term', 			array($this, 	'save_category_fields'), 10, 3);
			add_action('edit_term', 			array($this, 	'save_category_fields'), 10, 3);
			add_action('admin_enqueue_scripts', array(&$this, 	'register_scripts'));
		}
		
		public function register_scripts() {
			wp_register_script('wvs-term', 	WVS_PLUGIN_URL .'assets/js/wvs-term.js');
			wp_register_style('wvs-term', 	WVS_PLUGIN_URL .'assets/css/wvs-term.css');

			$translation_array = array(
				'uploadimage'    => __('Choose an image' , 'woovina-variation-swatches'),
				'useimage'       => __('Use Image' , 'woovina-variation-swatches'),
				'placeholder'    => WVS_PLACEHOLDER_IMG,
			);
			
			wp_localize_script('wvs-term', 'wvsterm', $translation_array);
		}
		
		public function setup_texonomy_based_fields(){
			global $woocommerce;

			$createdattributes = wc_get_attribute_taxonomies();

			foreach($createdattributes as $attribute) {
				add_action('pa_'. $attribute->attribute_name .'_add_form_fields', 		array($this, 'add_category_fields'));
				add_action('pa_'. $attribute->attribute_name .'_edit_form_fields', 		array($this, 'edit_category_fields'), 10, 2);
				add_filter('manage_edit-pa_'. $attribute->attribute_name .'_columns', 	array($this, 'term_columns'));
				add_filter('manage_pa_'. $attribute->attribute_name .'_custom_column', 	array($this, 'term_column'), 10, 3);
			}
		}
		
		public function add_category_fields() {
			wp_enqueue_media(); 
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_script('wvs-term');
			wp_enqueue_style('wvs-term');
			wp_enqueue_style('wp-color-picker');
		?>
		   
			<div class="category-field">
			
				<label><?php _e('Display Type', 'woovina-variation-swatches'); ?></label>
				<select id="display_type" name="display_type">
					<option value="Color"><?php _e('Color', 'woovina-variation-swatches'); ?></option>
					<option value="Image"><?php _e('Image', 'woovina-variation-swatches'); ?></option>
					<option value="textblock"><?php _e('Text Block', 'woovina-variation-swatches'); ?></option>
				</select>
				
				<br /><br />
				<div id="wvscolorp" style="display:block;">
					<label for="_chose_color"><span class="wvsformfield"><?php _e('Chose Color', 'woovina-variation-swatches'); ?></span></label> 
					<input name="color" type="text" class="wvsattributecolorselect" value="<?php if(isset($color)) { echo $color;} else { echo '#ffffff';}  ?>" data-default-color="#ffffff">
				</div>
				
				<br />
				<div id="wvsimagep" style="display:none;">
					<label><?php _e('Thumbnail', 'woovina-variation-swatches'); ?></label>
					<div id="facility_thumbnail_1" style="float:left;margin-right:10px;"><img src="<?php echo WVS_PLACEHOLDER_IMG; ?>" width="60px" height="60px" /></div>
					<div class="image-upload-div" style="line-height:60px;" idval="1">
						<input type="hidden" id="thumbnail_id_1" name="thumbnail_id" />
						<button type="button" class="wvs_upload_image_button_1 button"><?php _e('Upload/Add image', 'woovina-variation-swatches'); ?></button>
						<button type="button" class="wvs_remove_image_button_1 button"><?php _e('Remove image', 'woovina-variation-swatches'); ?></button>
					</div>
				</div>
				
				<br />
				<div id="wvshoverdiv" style="">
					<label><?php _e('Hover Image', 'woovina-variation-swatches'); ?></label>
					<div id="facility_thumbnail_2" style="float:left;margin-right:10px;"><img src="<?php echo WVS_PLACEHOLDER_IMG; ?>" width="60px" height="60px" /></div>
					<div class="image-upload-div" style="line-height:60px;" idval="2">
						<input type="hidden" id="thumbnail_id_2" name="hoverimage" />
						<button type="button" class="wvs_upload_image_button_2 button"><?php _e('Upload/Add image', 'woovina-variation-swatches'); ?></button>
						<button type="button" class="wvs_remove_image_button_2 button"><?php _e('Remove image', 'woovina-variation-swatches'); ?></button>
					</div>
				</div>
				
				<br />
				<div id="wvstextblockp" style="display:none;">
				  <label for="_textblock_text"><span class="wvsformfield"><?php _e('Text', 'woovina-variation-swatches'); ?></span></label> 
				  <input name="textblock" type="text" class="wvstextblockinput" value="">
				</div>
				
				<br />
				<div class="clear"></div>
			</div>
			
		<?php
		}
		
		public function edit_category_fields($term, $taxonomy) {
			wp_enqueue_media();
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_script('wvs-term');
			wp_enqueue_style('wp-color-picker');

			$image 			    = '';
			$thumbnail_id 	    = absint(get_term_meta($term->term_id, 'thumbnail_id', true));
			$hoverimage 	    = absint(get_term_meta($term->term_id, 'hoverimage', true));
			$display_type 	    = get_term_meta($term->term_id, 'display_type', true);
			$color 	            = get_term_meta($term->term_id, 'color', true);
			$textblock 	        = get_term_meta($term->term_id, 'textblock', true);
			
			$image 	= ($thumbnail_id) ? wp_get_attachment_thumb_url($thumbnail_id) : WVS_PLACEHOLDER_IMG;
			$image2 = ($hoverimage) ? wp_get_attachment_thumb_url($hoverimage) : WVS_PLACEHOLDER_IMG;
		?>
			<tr class="form-field">
				<th scope="row" valign="top"><label><?php _e('Display Type', 'woovina-variation-swatches'); ?></label></label></th>
				<td>
					<select id="display_type" name="display_type" >
						<option value="Color" <?php if(isset($display_type) && ($display_type == "Color")) { echo 'selected'; }  ?>><?php _e('Color', 'woovina-variation-swatches'); ?></option>
						<option value="Image" <?php if(isset($display_type) && ($display_type == "Image")) { echo 'selected'; }  ?>><?php _e('Image', 'woovina-variation-swatches'); ?></option>
						<option value="textblock" <?php if(isset($display_type) && ($display_type == "textblock")) { echo 'selected'; }  ?>><?php _e('Text Block', 'woovina-variation-swatches'); ?></option>
					</select>
				</td>
			</tr>
			
			<tr class="" id="wvscolorp" style="<?php if(isset($display_type) && (($display_type == "Image") || ($display_type == "textblock"))) { echo 'display:none;'; } else { echo 'display:;'; }  ?>">
				<th scope="row" valign="top"><label><?php _e('Chose Color', 'woovina-variation-swatches'); ?></label></label></th>
				<td><input name="color" type="text" class="wvsattributecolorselect" value="<?php if(isset($color)) { echo $color;} else { echo '#ffffff';}  ?>" data-default-color="#ffffff"></td>
			</tr>
			
			<tr class="form-field" id="wvsimagep" style="<?php if(isset($display_type) && ($display_type == "Image")) { echo 'display:;'; } else { echo 'display:none;'; }  ?>">
				<th scope="row" valign="top"><label><?php _e('Thumbnail', 'woovina-variation-swatches'); ?></label></th>
				<td>
					<div id="facility_thumbnail_1" style="float:left;margin-right:10px;"><img src="<?php echo $image; ?>" width="60px" height="60px" /></div>
					<div class="image-upload-div" style="line-height:60px;" idval="1">
						<input type="hidden" id="thumbnail_id_1" name="thumbnail_id" value="<?php echo $thumbnail_id; ?>" />
						<button type="submit" class="wvs_upload_image_button_1 button"><?php _e('Upload/Add image', 'woovina-variation-swatches'); ?></button>
						<button type="submit" class="wvs_remove_image_button_1 button"><?php _e('Remove image', 'woovina-variation-swatches'); ?></button>
					</div>					
					<div class="clear"></div>
				</td>
			</tr>
			
			<tr class="form-field" id="wvstextblockp" style="<?php if(isset($display_type) && ($display_type == "textblock")) { echo 'display:;'; } else { echo 'display:none;'; }  ?>">
			   <th scope="row" valign="top"><label><?php _e('Text', 'woovina-variation-swatches'); ?></label></label></th>
			   <td><input name="textblock" type="text" class="wvstextblockinput" value="<?php if(isset($textblock) && (!empty($textblock))) { echo $textblock;} elseif(isset($term->name)) { echo $term->name; } ?>"></td>
			</tr>
			
			<tr class="form-field" id="wvshoverdiv" style="">
				<th scope="row" valign="top"><label><?php _e('Hover Image', 'woovina-variation-swatches'); ?></label></th>
				<td>
					<div id="facility_thumbnail_2" style="float:left;margin-right:10px;"><img src="<?php echo $image2; ?>" width="60px" height="60px" /></div>
					<div class="image-upload-div" style="line-height:60px;" idval="2">
						<input type="hidden" id="thumbnail_id_2" name="hoverimage" value="<?php echo $hoverimage; ?>" />
						<button type="submit" class="wvs_upload_image_button_2 button"><?php _e('Upload/Add image', 'woovina-variation-swatches'); ?></button>
						<button type="submit" class="wvs_remove_image_button_2 button"><?php _e('Remove image', 'woovina-variation-swatches'); ?></button>
					</div>					
					<div class="clear"></div>
				</td>
			</tr>
			<?php
		}

		public function save_category_fields($term_id, $tt_id, $taxonomy) {
		
			if(isset($_POST['thumbnail_id'])) update_woocommerce_term_meta($term_id, 'thumbnail_id', absint($_POST['thumbnail_id']));

			if(isset($_POST['hoverimage'])) update_woocommerce_term_meta($term_id, 'hoverimage', absint($_POST['hoverimage']));

			if(isset($_POST['display_type'])) update_woocommerce_term_meta($term_id, 'display_type',  $_POST['display_type']);

			if(isset($_POST['color'])) update_woocommerce_term_meta($term_id, 'color',  $_POST['color']);

			if(isset($_POST['textblock'])) update_woocommerce_term_meta($term_id, 'textblock',  $_POST['textblock']);

			delete_transient('wc_term_counts');
		}
		
		public function term_columns($columns) {
			$new_columns          		= array();
			$new_columns['cb']    		= $columns['cb'];
			$new_columns['thumb'] 		= __('Preview', 'woovina-variation-swatches');
			$new_columns['hoverimage'] 	= __('Hover Image', 'woovina-variation-swatches');

			unset($columns['cb']);

			return array_merge($new_columns, $columns);
		}
		
		public function term_column($columns, $column, $id) {

			if($column == 'thumb') {

				$image 			    = '';
				$thumbnail_id 	    = get_term_meta($id, 'thumbnail_id', true);
				$color 	            = get_term_meta($id, 'color', true);
				$textblock 	        = get_term_meta($id, 'textblock', true);
				
				$image = ($thumbnail_id) ? wp_get_attachment_thumb_url($thumbnail_id) : WVS_PLACEHOLDER_IMG;
				$display_type 	= get_term_meta($id, 'display_type', true);	
					
					
				if(isset($display_type)) {
					switch($display_type) {
						case "Color":
							$columns .= '<div style="background-color:'.$color.'; border: solid 2px white; outline: solid 1px #9C9999; width:32px; height:32px;"></div>';
						break;

						case "Image":
							$columns .= '<div style="border: solid 2px white; outline: solid 1px #9C9999; width:32px; height:32px;"><img src="'. esc_url($image) .'" alt="Thumbnail" class="wp-post-image" /></div>';
						break;

						case "textblock":
							$columns .= '<div style="display: inline-block; border: solid 2px white; outline: solid 1px #9C9999; height: auto; width: auto; max-width: 100%; background-color: #eee;
						color: black; border-radius: 3px; font-size: 14px!important;font-weight: 500; padding: 3px 6px;" width="auto" height="32">'. $textblock .'</div>';
						break;
					}
				}
			}
			
			if($column == 'hoverimage') {
				$image2 			    = '';
				$thumbnail_id 	    = get_term_meta($id, 'thumbnail_id', true);
				$hoverimage 	    = get_term_meta($id, 'hoverimage', true);
				
				$image2 = ($hoverimage) ? wp_get_attachment_thumb_url($hoverimage) : WVS_PLACEHOLDER_IMG;
				
				$columns .= '<div style="border: solid 2px white; outline: solid 1px #9C9999; width:32px; height:32px;"><img src="'. esc_url($image2) .'" alt="Thumbnail" class="wp-post-image" /></div>';
			}

			return $columns;
		}

	}
}

new WooVina_WVS_Global_Attribute();
