<?php
/**
 * Variable product add to cart
 *
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */
if(! defined('ABSPATH')) {
	exit;
}

global $product,$post;

$attribute_keys          =  array_keys($attributes);
$_coloredvariables       =  get_post_meta($post->ID, '_coloredvariables', true);
$wvs_global_activation   =  get_option("wvs_woocommerce_global_activation");
$wvs_global              =  get_option("wvs_global");
$product_id              =  $product->get_id(); 	
$wvs_show_selected       =  get_option('wvs_show_selected_attribute_name');
$wvs_custom_clear_text   =  get_option('woocommerce_custom_clear_text');
$variations              =  $product->get_available_variations();
$woocommerce_clear_text  = (isset ($wvs_custom_clear_text) && ($wvs_custom_clear_text != '')) ? $wvs_custom_clear_text : __('Clear selection', 'woovina-variation-swatches');
$outofstock_array        = array();

foreach($variations as $vkey => $variation) {
	if($variation['is_in_stock'] != 1) {
		$outofstock_array[] = $variation['attributes'];
	}
}
do_action('woocommerce_before_add_to_cart_form'); 
?>
<form class="variations_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint($product_id); ?>" data-product_variations="<?php echo esc_attr(json_encode($available_variations)) ?>">
	<?php do_action('woocommerce_before_variations_form'); ?>

	<?php if(empty($available_variations) && false !== $available_variations) : ?>
		<p class="stock out-of-stock"><?php _e('This product is currently out of stock and unavailable.', 'woocommerce'); ?></p>
	<?php else : ?>
		<table class="variations wvs-variations-wrapper" cellspacing="0">
			<tbody>
				<?php 
				foreach($attributes as $attribute_name => $options) { 
				    
				    if(isset($_coloredvariables[$attribute_name]['display_type'])) {
                        $attribute_display_type = $_coloredvariables[$attribute_name]['display_type'];
		            } 
					elseif((isset($wvs_global_activation)) && ($wvs_global_activation == 'yes') && isset($wvs_global[$attribute_name]))  {
						$attribute_display_type = $wvs_global[$attribute_name]['display_type'];
					} 
				    
					if(isset($attribute_display_type)) {
						$attribute_display_type = apply_filters('wvs_attribute_display_type', $attribute_display_type, $attribute_name);
					}
					
                    $labeltext  = wc_attribute_label($attribute_name);
				    $taxonomies = array($attribute_name);
					$args 		= array(
						'hide_empty' => 0
					);
                    
					$newvalues 		= get_terms($taxonomies, $args);
					$fields   		= new WooVina_WVS_Swatch_Form_Fields();
					$selected 		= isset($_REQUEST[ 'attribute_'. sanitize_title($attribute_name) ]) ? wc_clean(   $_REQUEST[ 'attribute_'. sanitize_title($attribute_name) ]) : $product->get_variation_default_attribute($attribute_name);
					$terms_selected = wc_get_product_terms($product_id, $attribute_name, array('fields' => 'all'));
                    $selected_text 	= $selected;			
									
                    foreach($terms_selected as $term_selected) {
							  
                        if(!in_array($term_selected->slug, $options)) continue; { 
										  
							$selected_text = get_term_by('slug', $selected, $attribute_name);	
                            if(isset($selected_text->name)) { $selected_text = $selected_text->name; }				
					    
						}
					}
				?>
				<tr>
					<td class="label">
					  <span class="swatchtitlelabel"><?php if(isset($labeltext) && ($labeltext != '')) { echo $labeltext; } ?></span>
					<?php if($wvs_show_selected == 'yes') { ?>
					  <span class="wvs_attribute_sep">:</span> <span class="wvs_selected_attribute "><?php echo $selected_text; ?></span>
					<?php } ?>
					</td>

					<td class="value <?php echo $attribute_display_type; ?>">
					<?php
						if(isset($attribute_display_type) && ($attribute_display_type  == "colororimage")) {
							wvs_dropdown_variation_attribute_options1(array('options' => $options, 'attribute' =>        $attribute_name, 'product' => $product, 'selected' => $selected));
						
							$extra = array(
							   "display_type" => $attribute_display_type
							);
							
							$fields->wvs_load_colored_select($product,$attribute_name,$options,$_coloredvariables,$newvalues,$selected,$extra);
						} 
						elseif(isset($attribute_display_type) && ($attribute_display_type  == "variationimage")) {
							wvs_dropdown_variation_attribute_options1(array('options' => $options, 'attribute' =>        $attribute_name, 'product' => $product, 'selected' => $selected));
							
							$extra = array(
							   "display_type" => $attribute_display_type
							);
							
							$fields->wvs_load_colored_select($product,$attribute_name,$options,$_coloredvariables,$newvalues,$selected,$extra);
						} 
						elseif(isset($attribute_display_type) && ($attribute_display_type  == "global")) {
							
							if(isset($wvs_global[$attribute_name])) {
								$wvs_global_display_type  = $wvs_global[$attribute_name]['display_type'];
							}
							
							if(isset($wvs_global_display_type) && ($wvs_global_display_type == "colororimage")) {
								wvs_dropdown_variation_attribute_options1(array('options' => $options, 'attribute' =>        $attribute_name, 'product' => $product, 'selected' => $selected));
								$fields->wvs_load_colored_select2($product,$attribute_name,$options,$newvalues,$selected);
							} 
							else {
								wvs_dropdown_variation_attribute_options2(array('options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected));
							}
						} else {
							wvs_dropdown_variation_attribute_options2(array('options' => $options, 'attribute' =>        $attribute_name, 'product' => $product, 'selected' => $selected));
							echo '<br />';
						}
						do_action('wvs_after_attribute_swatches',$attribute_name);
					?>
					</td>
				</tr>
		        <?php } ?>
							   
				<tr>
					<td colspan="2">
					<?php 
						if(isset($attribute_name)) {
						   echo end($attribute_keys) === $attribute_name ? '<a class="reset_variations" href="#">'. __($woocommerce_clear_text, 'woovina-variation-swatches') .'</a>' : ''; 
						}
					 ?> 
					</td>
				</tr>
			</tbody>
		</table>
		
        <div class="single_variation_wrap">
			<?php
				/**
				 * woocommerce_before_single_variation Hook
				 */
				do_action('woocommerce_before_single_variation');

				/**
				 * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
				 * @since 2.4.0
				 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
				 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
				 */
				do_action('woocommerce_single_variation');

				/**
				 * woocommerce_after_single_variation Hook
				 */
				do_action('woocommerce_after_single_variation');
			?>
		</div>
	<?php endif; ?>

	<?php do_action('woocommerce_after_variations_form'); ?>
</form>

<script>
	var wvs_attribute_number = <?php echo count($attributes); ?>;
	var outofstock_array      = <?php print_r(json_encode($outofstock_array)); ?>;
</script>
<?php do_action('woocommerce_after_add_to_cart_form'); ?>
