<?php

/**
 * SMSCampaignsApi
 * PHP version 5
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 * SendinBlue API
 *
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.12
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
namespace WPMailSMTP\Vendor\SendinBlue\Client\Api;

use WPMailSMTP\Vendor\GuzzleHttp\Client;
use WPMailSMTP\Vendor\GuzzleHttp\ClientInterface;
use WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request;
use WPMailSMTP\Vendor\GuzzleHttp\RequestOptions;
use WPMailSMTP\Vendor\SendinBlue\Client\ApiException;
use WPMailSMTP\Vendor\SendinBlue\Client\Configuration;
use WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector;
use WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer;
/**
 * SMSCampaignsApi Class Doc Comment
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SMSCampaignsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;
    /**
     * @var Configuration
     */
    protected $config;
    /**
     * @var HeaderSelector
     */
    protected $headerSelector;
    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(\WPMailSMTP\Vendor\GuzzleHttp\ClientInterface $client = null, \WPMailSMTP\Vendor\SendinBlue\Client\Configuration $config = null, \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector $selector = null)
    {
        $this->client = $client ?: new \WPMailSMTP\Vendor\GuzzleHttp\Client();
        $this->config = $config ?: new \WPMailSMTP\Vendor\SendinBlue\Client\Configuration();
        $this->headerSelector = $selector ?: new \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector();
    }
    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }
    /**
     * Operation createSmsCampaign
     *
     * Creates an SMS campaign
     *
     * @param  \SendinBlue\Client\Model\CreateSmsCampaign $createSmsCampaign Values to create an SMS Campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\CreateModel
     */
    public function createSmsCampaign($createSmsCampaign)
    {
        list($response) = $this->createSmsCampaignWithHttpInfo($createSmsCampaign);
        return $response;
    }
    /**
     * Operation createSmsCampaignWithHttpInfo
     *
     * Creates an SMS campaign
     *
     * @param  \SendinBlue\Client\Model\CreateSmsCampaign $createSmsCampaign Values to create an SMS Campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\CreateModel, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSmsCampaignWithHttpInfo($createSmsCampaign)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreateModel';
        $request = $this->createSmsCampaignRequest($createSmsCampaign);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreateModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createSmsCampaignAsync
     *
     * Creates an SMS campaign
     *
     * @param  \SendinBlue\Client\Model\CreateSmsCampaign $createSmsCampaign Values to create an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSmsCampaignAsync($createSmsCampaign)
    {
        return $this->createSmsCampaignAsyncWithHttpInfo($createSmsCampaign)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation createSmsCampaignAsyncWithHttpInfo
     *
     * Creates an SMS campaign
     *
     * @param  \SendinBlue\Client\Model\CreateSmsCampaign $createSmsCampaign Values to create an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSmsCampaignAsyncWithHttpInfo($createSmsCampaign)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreateModel';
        $request = $this->createSmsCampaignRequest($createSmsCampaign);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'createSmsCampaign'
     *
     * @param  \SendinBlue\Client\Model\CreateSmsCampaign $createSmsCampaign Values to create an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createSmsCampaignRequest($createSmsCampaign)
    {
        // verify the required parameter 'createSmsCampaign' is set
        if ($createSmsCampaign === null || \is_array($createSmsCampaign) && \count($createSmsCampaign) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $createSmsCampaign when calling createSmsCampaign');
        }
        $resourcePath = '/smsCampaigns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // body params
        $_tempBody = null;
        if (isset($createSmsCampaign)) {
            $_tempBody = $createSmsCampaign;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation deleteSmsCampaign
     *
     * Delete an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSmsCampaign($campaignId)
    {
        $this->deleteSmsCampaignWithHttpInfo($campaignId);
    }
    /**
     * Operation deleteSmsCampaignWithHttpInfo
     *
     * Delete an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSmsCampaignWithHttpInfo($campaignId)
    {
        $returnType = '';
        $request = $this->deleteSmsCampaignRequest($campaignId);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteSmsCampaignAsync
     *
     * Delete an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSmsCampaignAsync($campaignId)
    {
        return $this->deleteSmsCampaignAsyncWithHttpInfo($campaignId)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation deleteSmsCampaignAsyncWithHttpInfo
     *
     * Delete an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSmsCampaignAsyncWithHttpInfo($campaignId)
    {
        $returnType = '';
        $request = $this->deleteSmsCampaignRequest($campaignId);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'deleteSmsCampaign'
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteSmsCampaignRequest($campaignId)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling deleteSmsCampaign');
        }
        $resourcePath = '/smsCampaigns/{campaignId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('DELETE', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation getSmsCampaign
     *
     * Get an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetSmsCampaign
     */
    public function getSmsCampaign($campaignId)
    {
        list($response) = $this->getSmsCampaignWithHttpInfo($campaignId);
        return $response;
    }
    /**
     * Operation getSmsCampaignWithHttpInfo
     *
     * Get an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetSmsCampaign, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSmsCampaignWithHttpInfo($campaignId)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaign';
        $request = $this->getSmsCampaignRequest($campaignId);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaign', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSmsCampaignAsync
     *
     * Get an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsCampaignAsync($campaignId)
    {
        return $this->getSmsCampaignAsyncWithHttpInfo($campaignId)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getSmsCampaignAsyncWithHttpInfo
     *
     * Get an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsCampaignAsyncWithHttpInfo($campaignId)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaign';
        $request = $this->getSmsCampaignRequest($campaignId);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getSmsCampaign'
     *
     * @param  int $campaignId id of the SMS campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getSmsCampaignRequest($campaignId)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling getSmsCampaign');
        }
        $resourcePath = '/smsCampaigns/{campaignId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation getSmsCampaigns
     *
     * Returns the information for all your created SMS campaigns
     *
     * @param  string $status Status of campaign. (optional)
     * @param  \DateTime $startDate Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  \DateTime $endDate Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  int $limit Number limitation for the result returned (optional, default to 500)
     * @param  int $offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetSmsCampaigns
     */
    public function getSmsCampaigns($status = null, $startDate = null, $endDate = null, $limit = '500', $offset = '0', $sort = 'desc')
    {
        list($response) = $this->getSmsCampaignsWithHttpInfo($status, $startDate, $endDate, $limit, $offset, $sort);
        return $response;
    }
    /**
     * Operation getSmsCampaignsWithHttpInfo
     *
     * Returns the information for all your created SMS campaigns
     *
     * @param  string $status Status of campaign. (optional)
     * @param  \DateTime $startDate Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  \DateTime $endDate Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  int $limit Number limitation for the result returned (optional, default to 500)
     * @param  int $offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetSmsCampaigns, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSmsCampaignsWithHttpInfo($status = null, $startDate = null, $endDate = null, $limit = '500', $offset = '0', $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaigns';
        $request = $this->getSmsCampaignsRequest($status, $startDate, $endDate, $limit, $offset, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaigns', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSmsCampaignsAsync
     *
     * Returns the information for all your created SMS campaigns
     *
     * @param  string $status Status of campaign. (optional)
     * @param  \DateTime $startDate Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  \DateTime $endDate Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  int $limit Number limitation for the result returned (optional, default to 500)
     * @param  int $offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsCampaignsAsync($status = null, $startDate = null, $endDate = null, $limit = '500', $offset = '0', $sort = 'desc')
    {
        return $this->getSmsCampaignsAsyncWithHttpInfo($status, $startDate, $endDate, $limit, $offset, $sort)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getSmsCampaignsAsyncWithHttpInfo
     *
     * Returns the information for all your created SMS campaigns
     *
     * @param  string $status Status of campaign. (optional)
     * @param  \DateTime $startDate Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  \DateTime $endDate Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  int $limit Number limitation for the result returned (optional, default to 500)
     * @param  int $offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSmsCampaignsAsyncWithHttpInfo($status = null, $startDate = null, $endDate = null, $limit = '500', $offset = '0', $sort = 'desc')
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetSmsCampaigns';
        $request = $this->getSmsCampaignsRequest($status, $startDate, $endDate, $limit, $offset, $sort);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getSmsCampaigns'
     *
     * @param  string $status Status of campaign. (optional)
     * @param  \DateTime $startDate Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  \DateTime $endDate Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; ) (optional)
     * @param  int $limit Number limitation for the result returned (optional, default to 500)
     * @param  int $offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param  string $sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getSmsCampaignsRequest($status = null, $startDate = null, $endDate = null, $limit = '500', $offset = '0', $sort = 'desc')
    {
        if ($limit !== null && $limit > 1000) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling SMSCampaignsApi.getSmsCampaigns, must be smaller than or equal to 1000.');
        }
        $resourcePath = '/smsCampaigns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // query params
        if ($status !== null) {
            $queryParams['status'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($status);
        }
        // query params
        if ($startDate !== null) {
            $queryParams['startDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($startDate);
        }
        // query params
        if ($endDate !== null) {
            $queryParams['endDate'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($endDate);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toQueryValue($sort);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation requestSmsRecipientExport
     *
     * Export an SMS campaign's recipients
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\RequestSmsRecipientExport $recipientExport Values to send for a recipient export request (optional)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\CreatedProcessId
     */
    public function requestSmsRecipientExport($campaignId, $recipientExport = null)
    {
        list($response) = $this->requestSmsRecipientExportWithHttpInfo($campaignId, $recipientExport);
        return $response;
    }
    /**
     * Operation requestSmsRecipientExportWithHttpInfo
     *
     * Export an SMS campaign's recipients
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\RequestSmsRecipientExport $recipientExport Values to send for a recipient export request (optional)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\CreatedProcessId, HTTP status code, HTTP response headers (array of strings)
     */
    public function requestSmsRecipientExportWithHttpInfo($campaignId, $recipientExport = null)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreatedProcessId';
        $request = $this->requestSmsRecipientExportRequest($campaignId, $recipientExport);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreatedProcessId', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation requestSmsRecipientExportAsync
     *
     * Export an SMS campaign's recipients
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\RequestSmsRecipientExport $recipientExport Values to send for a recipient export request (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function requestSmsRecipientExportAsync($campaignId, $recipientExport = null)
    {
        return $this->requestSmsRecipientExportAsyncWithHttpInfo($campaignId, $recipientExport)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation requestSmsRecipientExportAsyncWithHttpInfo
     *
     * Export an SMS campaign's recipients
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\RequestSmsRecipientExport $recipientExport Values to send for a recipient export request (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function requestSmsRecipientExportAsyncWithHttpInfo($campaignId, $recipientExport = null)
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\CreatedProcessId';
        $request = $this->requestSmsRecipientExportRequest($campaignId, $recipientExport);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'requestSmsRecipientExport'
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\RequestSmsRecipientExport $recipientExport Values to send for a recipient export request (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function requestSmsRecipientExportRequest($campaignId, $recipientExport = null)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling requestSmsRecipientExport');
        }
        $resourcePath = '/smsCampaigns/{campaignId}/exportRecipients';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($recipientExport)) {
            $_tempBody = $recipientExport;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation sendSmsCampaignNow
     *
     * Send your SMS campaign immediately
     *
     * @param  int $campaignId id of the campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function sendSmsCampaignNow($campaignId)
    {
        $this->sendSmsCampaignNowWithHttpInfo($campaignId);
    }
    /**
     * Operation sendSmsCampaignNowWithHttpInfo
     *
     * Send your SMS campaign immediately
     *
     * @param  int $campaignId id of the campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendSmsCampaignNowWithHttpInfo($campaignId)
    {
        $returnType = '';
        $request = $this->sendSmsCampaignNowRequest($campaignId);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 402:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation sendSmsCampaignNowAsync
     *
     * Send your SMS campaign immediately
     *
     * @param  int $campaignId id of the campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsCampaignNowAsync($campaignId)
    {
        return $this->sendSmsCampaignNowAsyncWithHttpInfo($campaignId)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation sendSmsCampaignNowAsyncWithHttpInfo
     *
     * Send your SMS campaign immediately
     *
     * @param  int $campaignId id of the campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsCampaignNowAsyncWithHttpInfo($campaignId)
    {
        $returnType = '';
        $request = $this->sendSmsCampaignNowRequest($campaignId);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'sendSmsCampaignNow'
     *
     * @param  int $campaignId id of the campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendSmsCampaignNowRequest($campaignId)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling sendSmsCampaignNow');
        }
        $resourcePath = '/smsCampaigns/{campaignId}/sendNow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation sendSmsReport
     *
     * Send an SMS campaign's report
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\SendReport $sendReport Values for send a report (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function sendSmsReport($campaignId, $sendReport)
    {
        $this->sendSmsReportWithHttpInfo($campaignId, $sendReport);
    }
    /**
     * Operation sendSmsReportWithHttpInfo
     *
     * Send an SMS campaign's report
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\SendReport $sendReport Values for send a report (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendSmsReportWithHttpInfo($campaignId, $sendReport)
    {
        $returnType = '';
        $request = $this->sendSmsReportRequest($campaignId, $sendReport);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation sendSmsReportAsync
     *
     * Send an SMS campaign's report
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\SendReport $sendReport Values for send a report (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsReportAsync($campaignId, $sendReport)
    {
        return $this->sendSmsReportAsyncWithHttpInfo($campaignId, $sendReport)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation sendSmsReportAsyncWithHttpInfo
     *
     * Send an SMS campaign's report
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\SendReport $sendReport Values for send a report (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsReportAsyncWithHttpInfo($campaignId, $sendReport)
    {
        $returnType = '';
        $request = $this->sendSmsReportRequest($campaignId, $sendReport);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'sendSmsReport'
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\SendReport $sendReport Values for send a report (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendSmsReportRequest($campaignId, $sendReport)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling sendSmsReport');
        }
        // verify the required parameter 'sendReport' is set
        if ($sendReport === null || \is_array($sendReport) && \count($sendReport) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $sendReport when calling sendSmsReport');
        }
        $resourcePath = '/smsCampaigns/{campaignId}/sendReport';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($sendReport)) {
            $_tempBody = $sendReport;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation sendTestSms
     *
     * Send a test SMS campaign
     *
     * @param  int $campaignId Id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\SendTestSms $phoneNumber Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function sendTestSms($campaignId, $phoneNumber)
    {
        $this->sendTestSmsWithHttpInfo($campaignId, $phoneNumber);
    }
    /**
     * Operation sendTestSmsWithHttpInfo
     *
     * Send a test SMS campaign
     *
     * @param  int $campaignId Id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\SendTestSms $phoneNumber Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendTestSmsWithHttpInfo($campaignId, $phoneNumber)
    {
        $returnType = '';
        $request = $this->sendTestSmsRequest($campaignId, $phoneNumber);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\PostSendSmsTestFailed', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation sendTestSmsAsync
     *
     * Send a test SMS campaign
     *
     * @param  int $campaignId Id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\SendTestSms $phoneNumber Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendTestSmsAsync($campaignId, $phoneNumber)
    {
        return $this->sendTestSmsAsyncWithHttpInfo($campaignId, $phoneNumber)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation sendTestSmsAsyncWithHttpInfo
     *
     * Send a test SMS campaign
     *
     * @param  int $campaignId Id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\SendTestSms $phoneNumber Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendTestSmsAsyncWithHttpInfo($campaignId, $phoneNumber)
    {
        $returnType = '';
        $request = $this->sendTestSmsRequest($campaignId, $phoneNumber);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'sendTestSms'
     *
     * @param  int $campaignId Id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\SendTestSms $phoneNumber Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendTestSmsRequest($campaignId, $phoneNumber)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling sendTestSms');
        }
        // verify the required parameter 'phoneNumber' is set
        if ($phoneNumber === null || \is_array($phoneNumber) && \count($phoneNumber) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $phoneNumber when calling sendTestSms');
        }
        $resourcePath = '/smsCampaigns/{campaignId}/sendTest';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($phoneNumber)) {
            $_tempBody = $phoneNumber;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation updateSmsCampaign
     *
     * Update an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateSmsCampaign $updateSmsCampaign Values to update an SMS Campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSmsCampaign($campaignId, $updateSmsCampaign)
    {
        $this->updateSmsCampaignWithHttpInfo($campaignId, $updateSmsCampaign);
    }
    /**
     * Operation updateSmsCampaignWithHttpInfo
     *
     * Update an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateSmsCampaign $updateSmsCampaign Values to update an SMS Campaign (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSmsCampaignWithHttpInfo($campaignId, $updateSmsCampaign)
    {
        $returnType = '';
        $request = $this->updateSmsCampaignRequest($campaignId, $updateSmsCampaign);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateSmsCampaignAsync
     *
     * Update an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateSmsCampaign $updateSmsCampaign Values to update an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSmsCampaignAsync($campaignId, $updateSmsCampaign)
    {
        return $this->updateSmsCampaignAsyncWithHttpInfo($campaignId, $updateSmsCampaign)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation updateSmsCampaignAsyncWithHttpInfo
     *
     * Update an SMS campaign
     *
     * @param  int $campaignId id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateSmsCampaign $updateSmsCampaign Values to update an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSmsCampaignAsyncWithHttpInfo($campaignId, $updateSmsCampaign)
    {
        $returnType = '';
        $request = $this->updateSmsCampaignRequest($campaignId, $updateSmsCampaign);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'updateSmsCampaign'
     *
     * @param  int $campaignId id of the SMS campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateSmsCampaign $updateSmsCampaign Values to update an SMS Campaign (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateSmsCampaignRequest($campaignId, $updateSmsCampaign)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling updateSmsCampaign');
        }
        // verify the required parameter 'updateSmsCampaign' is set
        if ($updateSmsCampaign === null || \is_array($updateSmsCampaign) && \count($updateSmsCampaign) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $updateSmsCampaign when calling updateSmsCampaign');
        }
        $resourcePath = '/smsCampaigns/{campaignId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($updateSmsCampaign)) {
            $_tempBody = $updateSmsCampaign;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('PUT', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation updateSmsCampaignStatus
     *
     * Update a campaign's status
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateCampaignStatus $status Status of the campaign. (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSmsCampaignStatus($campaignId, $status)
    {
        $this->updateSmsCampaignStatusWithHttpInfo($campaignId, $status);
    }
    /**
     * Operation updateSmsCampaignStatusWithHttpInfo
     *
     * Update a campaign's status
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateCampaignStatus $status Status of the campaign. (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSmsCampaignStatusWithHttpInfo($campaignId, $status)
    {
        $returnType = '';
        $request = $this->updateSmsCampaignStatusRequest($campaignId, $status);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateSmsCampaignStatusAsync
     *
     * Update a campaign's status
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateCampaignStatus $status Status of the campaign. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSmsCampaignStatusAsync($campaignId, $status)
    {
        return $this->updateSmsCampaignStatusAsyncWithHttpInfo($campaignId, $status)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation updateSmsCampaignStatusAsyncWithHttpInfo
     *
     * Update a campaign's status
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateCampaignStatus $status Status of the campaign. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSmsCampaignStatusAsyncWithHttpInfo($campaignId, $status)
    {
        $returnType = '';
        $request = $this->updateSmsCampaignStatusRequest($campaignId, $status);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'updateSmsCampaignStatus'
     *
     * @param  int $campaignId id of the campaign (required)
     * @param  \SendinBlue\Client\Model\UpdateCampaignStatus $status Status of the campaign. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateSmsCampaignStatusRequest($campaignId, $status)
    {
        // verify the required parameter 'campaignId' is set
        if ($campaignId === null || \is_array($campaignId) && \count($campaignId) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $campaignId when calling updateSmsCampaignStatus');
        }
        // verify the required parameter 'status' is set
        if ($status === null || \is_array($status) && \count($status) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $status when calling updateSmsCampaignStatus');
        }
        $resourcePath = '/smsCampaigns/{campaignId}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($campaignId !== null) {
            $resourcePath = \str_replace('{' . 'campaignId' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($campaignId), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($status)) {
            $_tempBody = $status;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('PUT', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG] = \fopen($this->config->getDebugFile(), 'a');
            if (!$options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }
        return $options;
    }
}
