jQuery(document).ready(function(jQuery) {
    jQuery('.contact_pop_trigger').click(function() {
        jQuery('.contact-pop-main').fadeIn(500);
    });
    jQuery('.contact-close').click(function() {
        jQuery('.contact-pop-main').fadeOut(500);
        jQuery('.contact-success-message').hide();
    });
    jQuery('.sub-submit1').click(function(e) {
        var sEmail = jQuery('.email1').val();
        if (sEmail == "") {
            jQuery('#error_email').html('Please enter your email address.').show();
            jQuery('.email1').focus();
            return false;
        }
        if (!validateEmail(sEmail)) {
            jQuery('#error_email').html('Please enter valid email address.').show();
            jQuery('.email1').focus();
            return false;
        }
    });
    jQuery('.sub-submit').click(function(e) {
        var s2Email = jQuery('.s2email').val();
        if (s2Email == "") {
            jQuery('#error_email2').html('Please enter your email address.').show();
            jQuery('.s2email').focus();
            return false;
        }
        if (!validateEmail(s2Email)) {
            jQuery('#error_email2').html('Please enter valid email address.').show();
            jQuery('.s2email').focus();
            return false;
        }
    });
    jQuery('.subscribe-input-layout1').keyup(function() {
        var id_subscribe_field = jQuery(this).attr('id');
        if (id_subscribe_field == 'edmm-sub-email1') {
            jQuery('#error_email').html('');
        }
        if (id_subscribe_field == 'edmm-sub-email2') {
            jQuery('#error_email2').html('');
        }
    });
    
    /* Ajax contact */
    jQuery('.submit_contact').click(function(e) {
        var cname = jQuery('.contact_name_field').val();
        var cEmail = jQuery('.contact_email_field').val();
        var cMsg = jQuery('.contact_msg_field').val();
        var admin_mail = jQuery('.edmm-data').attr('admin-email');
        if (cname == "") {
            jQuery('#error_contact_name').html('Please enter your name.');
            jQuery('.contact_name_field').focus();
            jQuery('.contact-success-message').hide();
            return false;
        } else if (cEmail == "") {
            jQuery('#error_contact_email').html('Please enter your email address.');
            jQuery('.contact_email_field').focus();
            return false;
        } else if (!validateEmail(cEmail)) {
            jQuery('#error_contact_email').html('Please enter valid email address.');
            jQuery('.contact_email_field').focus();
            return false;
        } else if (cMsg == "") {
            jQuery('#error_contact_msg').html('Please enter your message.');
            jQuery('.contact_msg_field').focus();
            return false;
        } else {
            var success = jQuery('#edn-msg').data('success');
            var url = jQuery('.edmm-data').data('url');
            jQuery.ajax({
                url: url,
                type: 'post',
                data: {
                    name: cname,
                    email: cEmail,
                    msg: jQuery('.contact_msg_field').val(),
                    action: 'edn_coming_soon_ajax_action',
                    _wpnonce: jQuery('#edn-ajax-nonce').val()
                },
                beforeSend: function() {
                    jQuery('#edmm-loading').show('slow');
                },
                complete: function() {
                    jQuery('#edmm-loading').hide('slow');
                },
                success: function(resp) {
                    if (resp == 1) {
                        jQuery('.empty-common-contact').val('');
                        jQuery('.contact-success-message').html('Success! Thank you for contacting us').show();
                    } else {
                        jQuery('.contact-success-message').html('Sorry!! Please try again Later').show();
                    }
                }
            });
        }
    });
    jQuery('.empty-common-contact').keyup(function() {
        var id_of_element = jQuery(this).attr('id');
        if (id_of_element == 'edmm-contact-name') {
            jQuery('#error_contact_name').html('');
        }
        if (id_of_element == 'edmm-contact-email') {
            jQuery('#error_contact_email').html('');
        }
        if (id_of_element == 'edmm-contact-msg') {
            jQuery('#error_contact_msg').html('');
        }
    });
    var date = jQuery('input.date_val').val();
    if (!date == '') {
        var split_val_array = date.split('-');
        var year = split_val_array[0];
        var month = split_val_array[1];
        var day = split_val_array[2];
        var hour = jQuery('input.hour_val').val();
        var min = jQuery('input.minute_val').val();
        var sec = jQuery('input.second_val').val();
        jQuery('.countdown').downCount({
            date: month + '/' + day + '/' + year + ' 12:00:00'
        });
        jQuery('.countdown2').downCount({
            date: month + '/' + day + '/' + year + ' ' + hour + ':' + min + ':' + sec
        });
    }
});

/* Function that validates email address through a regular expression. */
function validateEmail(sEmail) {
    var filter = /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
    if (filter.test(sEmail)) {
        return true;
    } else {
        return false;
    }
}